% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.sign.switch.R
\name{post.sign.switch}
\alias{post.sign.switch}
\title{Perform sign switchting on posterior MCMC sample}
\usage{
post.sign.switch(mcmc, benchmark = NULL, benchmark.threshold = 0.5)
}
\arguments{
\item{mcmc}{Object of class '\code{befa}'.}

\item{benchmark}{Vector of integers of length equal to the maximum number of latent
factors. Each element indicates which factor loading is used as a
benchmark for the sign switch. If \code{NULL}, the factor loadings
with the highest posterior probabilities of being different from zero
in each column of the factor loading matrix are used as benchmarks.}

\item{benchmark.threshold}{Minimum posterior probability for a factor loading to be considered
as a benchmark.}
}
\value{
This function returns the same '\code{befa}' object, where the signs
of the factor loadings and of the factor correlations have been switched
appropriately to restore the identification of the factor model with respect
to sign switching.
}
\description{
This function performs a sign switch on the MCMC draws to restore the
consistency of the signs of the factors loadings and of the correlations of
the latent factors \emph{a posteriori}.
}
\details{
The signs of the factor loadings, as well as of the corresponding
correlations of the latent factors, are switched for each MCMC iteration such
that the factor loadings defined as \code{benchmark}s are positive. The sign
switch can only be performed if \code{\link{post.column.switch}} has been run
before. See section 4.3 (p.42) of CFSHP for more details.

If a latent factor has no benchmarks, or if its benchmark is equal to zero at
some MCMC iteration, then no sign switch is performed on the corresponding
loadings and correlations for this particular factor or MCMC iteration.

Note that in complicated models where the sampler visits several models with
different numbers of latent factors, it may not be relevant to use the
default value of \code{benchmark}, as the posterior probabilities that the
factor loadings are different from zero would be computed across models.
Instead, the user might consider finding the highest posterior probability
model first, and use its top elements in each column of the factor loading
matrix as benchmarks to perform the sign switch.
}
\examples{
set.seed(6)
Y <- simul.dedic.facmod(N = 100, dedic = rep(1:3, each = 5))
mcmc <- befa(Y, Kmax = 5, iter = 1000)
mcmc <- post.column.switch(mcmc)

# factor loadings corresponding to variables 1, 6, 11, 12 and 13 are
# used as benchmarks:
mcmc1 <- post.sign.switch(mcmc, benchmark = c(1, 6, 11, 12, 13))

# factor loadings with the highest posterior probability of being different
# from zero in each column are used as benchmark:
mcmc2 <- post.sign.switch(mcmc)

}
\references{
G. Conti, S. Frühwirth-Schnatter, J.J. Heckman,
R. Piatek (2014): ``Bayesian Exploratory Factor Analysis'',
\emph{Journal of Econometrics}, 183(1), pages 31-57,
\url{http://dx.doi.org/10.1016/j.jeconom.2014.06.008}.
}
\seealso{
\code{\link{post.column.switch}} for column switching of the factor
loading matrix and of the correlation matrix of the latent factors to restore
identification \emph{a posteriori}.
}
\author{
Rémi Piatek \email{remi.piatek@econ.ku.dk}
}
