% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_to_priors.R
\name{model_to_priors}
\alias{model_to_priors}
\title{Convert model's posteriors to priors (EXPERIMENTAL)}
\usage{
model_to_priors(model, scale_multiply = 3, ...)
}
\arguments{
\item{model}{A Bayesian model.}

\item{scale_multiply}{The SD of the posterior will be multiplied by this amount before being set as a prior to avoid overly narrow priors.}

\item{...}{Other arguments for \code{insight::get_prior()} or \code{\link{describe_posterior}}.}
}
\description{
Convert model's posteriors to (normal) priors.
}
\examples{
\donttest{
# brms models
# -----------------------------------------------
if (require("brms")) {
  formula <- brms::brmsformula(mpg ~ wt + cyl, center = FALSE)

  model <- brms::brm(formula, data = mtcars, refresh = 0)
  priors <- model_to_priors(model)
  priors <- brms::validate_prior(priors, formula, data = mtcars)
  priors

  model2 <- brms::brm(formula, data = mtcars, prior = priors, refresh = 0)
}
}
}
