% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcmd.R
\name{rcmd_copycat}
\alias{rcmd_copycat}
\title{Call and \verb{R CMD} command, while mimicking the current R session}
\usage{
rcmd_copycat(
  cmd,
  cmdargs = character(),
  libpath = .libPaths(),
  repos = getOption("repos"),
  env = character(),
  ...
)
}
\arguments{
\item{cmd}{Command to run. See \code{R --help} from the command
line for the various commands. In the current version of R (3.2.4)
these are: \code{BATCH}, \code{COMPILE}, \code{SHLIB}, \code{INSTALL}, \code{REMOVE}, \code{build},
\code{check}, \code{LINK}, \code{Rprof}, \code{Rdconv}, \code{Rd2pdf}, \code{Rd2txt}, \code{Stangle},
\code{Sweave}, \code{Rdiff}, \code{config}, \code{javareconf}, \code{rtags}.}

\item{cmdargs}{Command line arguments.}

\item{libpath}{The library path.}

\item{repos}{The \code{repos} option. If \code{NULL}, then no
\code{repos} option is set. This options is only used if
\code{user_profile} or \code{system_profile} is set \code{FALSE},
as it is set using the system or the user profile.}

\item{env}{Environment variables to set for the child process.}

\item{...}{Additional arguments are passed to \code{\link[=rcmd]{rcmd()}}.}
}
\description{
This function is similar to \code{\link[=rcmd]{rcmd()}}, but it has slightly different
defaults:
\itemize{
\item The \code{repos} options is unchanged.
\item No extra environment variables are defined.
}

\if{html}{\out{<link rel="stylesheet" type="text/css" href="../doc/assets/extra.css">}}

\if{html}{\out{<script src="../doc/assets/rd.js"></script>}}
}
\section{Security considerations}{


\code{callr} makes a copy of the user's \code{.Renviron} file and potentially of
the local or user \code{.Rprofile}, in the session temporary
directory. Avoid storing sensitive information such as passwords, in
your environment file or your profile, otherwise this information will
get scattered in various files, at least temporarily, until the
subprocess finishes. You can use the keyring package to avoid passwords
in plain files.
}

\seealso{
Other R CMD commands: 
\code{\link{rcmd_bg}()},
\code{\link{rcmd}()}
}
\concept{R CMD commands}
