% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rma-mv.R
\name{impute_covariance_matrix}
\alias{impute_covariance_matrix}
\title{Impute a block-diagonal covariance matrix}
\usage{
impute_covariance_matrix(vi, cluster, r,
  return_list = identical(as.factor(cluster), sort(as.factor(cluster))))
}
\arguments{
\item{vi}{Vector of variances}

\item{cluster}{Vector indicating which effects belong to the same cluster. 
Effects with the same value of `cluster` will be treated as correlated.}

\item{r}{Vector or numeric value of assume correlation(s) between effect size
estimates from each study.}

\item{return_list}{Optional logical indicating whether to return a list of matrices
(with one entry per block) or the full variance-covariance matrix.}
}
\value{
If \code{cluster} is appropriately sorted, then a list of matrices, 
  with one entry per cluster, will be returned by default. If \code{cluster}
  is out of order, then the full variance-covariate matrix will be returned
  by default. The output structure can be controlled with the optional
  \code{return_list} argument.
}
\description{
\code{impute_covariance_matrix} calculates a block-diagonal covariance 
matrix, given the marginal variances, the block structure, and an assumed 
correlation.
}
\examples{
library(metafor)
data(SATcoaching)
V_list <- impute_covariance_matrix(vi = SATcoaching$V, cluster = SATcoaching$study, r = 0.66)
MVFE <- rma.mv(d ~ 0 + test, V = V_list, data = SATcoaching)
coef_test(MVFE, vcov = "CR2", cluster = SATcoaching$study)

}
