% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_cohens_d.R
\name{interpret_cohens_d}
\alias{interpret_cohens_d}
\alias{interpret_hedges_g}
\alias{interpret_glass_delta}
\title{Interpret Standardized Differences}
\usage{
interpret_cohens_d(d, rules = "cohen1988", ...)

interpret_hedges_g(g, rules = "cohen1988")

interpret_glass_delta(delta, rules = "cohen1988")
}
\arguments{
\item{d, g, delta}{Value or vector of effect size values.}

\item{rules}{Can be \code{"cohen1988"} (default), \code{"gignac2016"},
\code{"sawilowsky2009"}, \code{"lovakov2021"} or a custom set of \code{\link[=rules]{rules()}}.}

\item{...}{Not directly used.}
}
\description{
Interpretation of standardized differences using different sets of rules of
thumb.
}
\section{Rules}{


Rules apply to equally to positive and negative \emph{d} (i.e., they are given as
absolute values).
\itemize{
\item Cohen (1988) (\code{"cohen1988"}; default)
\itemize{
\item \strong{d < 0.2} - Very small
\item \strong{0.2 <= d < 0.5} - Small
\item \strong{0.5 <= d < 0.8} - Medium
\item \strong{d >= 0.8} - Large
}
\item Sawilowsky (2009) (\code{"sawilowsky2009"})
\itemize{
\item \strong{d < 0.1} - Tiny
\item \strong{0.1 <= d < 0.2} - Very small
\item \strong{0.2 <= d < 0.5} - Small
\item \strong{0.5 <= d < 0.8} - Medium
\item \strong{0.8 <= d < 1.2} - Large
\item \strong{1.2 <= d < 2} - Very large
\item \strong{d >= 2} - Huge
}
\item Lovakov & Agadullina (2021) (\code{"lovakov2021"})
\itemize{
\item \strong{d < 0.15} - Very small
\item \strong{0.15 <= d < 0.36} - Small
\item \strong{0.36 <= d < 0.65} - Medium
\item \strong{d >= 0.65} - Large
}
\item Gignac & Szodorai (2016) (\code{"gignac2016"}, based on the \code{\link[=d_to_r]{d_to_r()}} conversion, see \code{\link[=interpret_r]{interpret_r()}})
\itemize{
\item \strong{d < 0.2} - Very small
\item \strong{0.2 <= d < 0.41} - Small
\item \strong{0.41 <= d < 0.63} - Moderate
\item \strong{d >= 0.63} - Large
}
}
}

\examples{
interpret_cohens_d(.02)
interpret_cohens_d(c(.5, .02))
interpret_cohens_d(.3, rules = "lovakov2021")
}
\references{
\itemize{
\item Lovakov, A., & Agadullina, E. R. (2021). Empirically Derived Guidelines for
Effect Size Interpretation in Social Psychology. European Journal of Social
Psychology.
\item Gignac, G. E., & Szodorai, E. T. (2016). Effect size guidelines for
individual differences researchers. Personality and individual differences,
102, 74-78.
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences
(2nd Ed.). New York: Routledge.
\item Sawilowsky, S. S. (2009). New effect size rules of thumb.
}
}
\keyword{interpreters}
