% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct.R
\name{fct}
\alias{fct}
\title{Create a factor}
\usage{
fct(x = character(), levels = NULL, na = character())
}
\arguments{
\item{x}{A character vector. Values must occur in either \code{levels} or \code{na}.}

\item{levels}{A character vector of known levels. If not supplied, will
be computed from the unique values of \code{x}, in the order in which they
occur.}

\item{na}{A character vector of values that should become missing values.}
}
\value{
A factor.
}
\description{
\code{fct()} is a stricter version of \code{\link[=factor]{factor()}} that errors if your
specification of \code{levels} is inconsistent with the values in \code{x}.
}
\examples{
# Use factors when you know the set of possible values a variable might take
x <- c("A", "O", "O", "AB", "A")
fct(x, levels = c("O", "A", "B", "AB"))

# If you don't specify the levels, fct will create from the data
# in the order that they're seen
fct(x)


# Differences with base R -----------------------------------------------
# factor() silently generates NAs
x <- c("a", "b", "c")
factor(x, levels = c("a", "b"))
# fct() errors
try(fct(x, levels = c("a", "b")))
# Unless you explicitly supply NA:
fct(x, levels = c("a", "b"), na = "c")

# factor() sorts default levels:
factor(c("y", "x"))
# fct() uses in order of appearance:
fct(c("y", "x"))
}
