% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gargle_oauth_client.R
\name{gargle_oauth_client_from_json}
\alias{gargle_oauth_client_from_json}
\alias{gargle_oauth_client}
\title{Create an OAuth client for Google}
\usage{
gargle_oauth_client_from_json(path, name = NULL)

gargle_oauth_client(
  id,
  secret,
  redirect_uris = NULL,
  type = c("installed", "web"),
  name = hash(id)
)
}
\arguments{
\item{path}{JSON downloaded from \href{https://console.cloud.google.com}{Google Cloud Console}, containing a client id and
secret, in one of the forms supported for the \code{txt} argument of
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a file path or JSON string).}

\item{name}{A label for this specific client, presumably the same name used
to label it in Google Cloud Console. Unfortunately there is no way to
make that true programmatically, i.e. the JSON representation does not
contain this information.}

\item{id}{Client ID}

\item{secret}{Client secret}

\item{redirect_uris}{Where your application listens for the response from
Google's authorization server. If you didn't configure this specifically
when creating the client (which is only possible for clients of the "web"
type), you can leave this unspecified.}

\item{type}{Specifies the type of OAuth client. The valid values are a subset
of possible Google client types and reflect the key used to describe the
client in its JSON representation:
\itemize{
\item \code{"installed"} is associated with a "Desktop app"
\item \code{"web"} is associated with a "Web application"
}}
}
\value{
An OAuth client: An S3 list with class \code{gargle_oauth_client}. For
backwards compatibility reasons, this currently also inherits from the httr
S3 class \code{oauth_app}, but that is a temporary measure. An instance of
\code{gargle_oauth_client} stores more information than httr's \code{oauth_app}, such
as the OAuth client's type ("web" or "installed").

There are some redundant fields in this object during the httr-to-httr2
transition period. The legacy fields \code{appname} and \code{key} repeat the
information in the future-facing fields \code{name} and (client) \code{id}. Prefer
\code{name} and \code{id} to \code{appname} and \code{key} in downstream code. Prefer the
constructors \code{gargle_oauth_client_from_json()} and \code{gargle_oauth_client()}
to \code{\link[httr:oauth_app]{httr::oauth_app()}} and \code{\link[=oauth_app_from_json]{oauth_app_from_json()}}.
}
\description{
A \code{gargle_oauth_client} consists of:
\itemize{
\item A type. gargle only supports the "Desktop app" and "Web application" client
types. Different types are associated with different OAuth flows.
\item A client ID and secret.
\item Optionally, one or more redirect URIs.
\item A name. This is really a human-facing label. Or, rather, it can be used
that way, but the default is just a hash. We recommend using the same name
here as the name used to label the client ID in the \href{https://console.cloud.google.com}{Google Cloud Platform Console}.
}

A \code{gargle_oauth_client} is an adaptation of httr's \code{\link[=oauth_app]{oauth_app()}} (currently)
and httr2's \code{oauth_client()} (which gargle will migrate to in the future).
}
\examples{
\dontrun{
gargle_oauth_client_from_json(
  path = "/path/to/the/JSON/you/downloaded/from/gcp/console.json",
  name = "my-nifty-oauth-client"
)
}

gargle_oauth_client(
  id = "some_long_id",
  secret = "ssshhhhh_its_a_secret",
  name = "my-nifty-oauth-client"
)
}
