% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-nlme.R
\name{getIndexOmega2-internal}
\alias{getIndexOmega2-internal}
\alias{.getIndexOmega2}
\alias{.getIndexOmega2.gls}
\alias{.getIndexOmega2.lme}
\title{Extract the name of the endogenous variables}
\usage{
.getIndexOmega2(object, ...)

\method{.getIndexOmega2}{gls}(
  object,
  param,
  attr.param,
  name.Y,
  cluster,
  levels.cluster,
  data
)

\method{.getIndexOmega2}{lme}(
  object,
  param,
  attr.param,
  name.Y,
  cluster,
  levels.cluster,
  data
)
}
\arguments{
\item{object}{a \code{gls} or \code{lme} object.}

\item{...}{[internal] Only used by the generic method.}

\item{param}{[numeric vector] the mean and variance coefficients.}

\item{attr.param}{[character vector] the type of each coefficients (mean or variance).}

\item{name.Y}{[character] name of the endogenous variable.}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.
Only required for \code{gls} models with no correlation argument.}

\item{data}{[data.frame] the data set.}
}
\value{
A list containing:
\itemize{
\item index.Omega: [list of integer vector] For each cluster of observations,
the index of the endogenous variable relative to each observation.
\item n.endogenous: [integer] the number of endogenous variables.
\item name.endogenous: [character vector] the name of the endogenous variables.
\item ref.group: [character vector] the levels of the variable defining the variance component in a generic covariance matrix.
}
}
\description{
Extract the name of the endogenous variables from a nlme model.
}
\concept{extractor}
\keyword{internal}
