% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contest.R
\name{contest.lmerModLmerTest}
\alias{contest.lmerModLmerTest}
\alias{contest.lmerMod}
\title{Test of Contrasts}
\usage{
\method{contest}{lmerModLmerTest}(model, L, rhs = 0, joint = TRUE,
  collect = TRUE, confint = TRUE, level = 0.95,
  check_estimability = FALSE, ddf = c("Satterthwaite", "Kenward-Roger",
  "lme4"), ...)

\method{contest}{lmerMod}(model, L, rhs = 0, joint = TRUE,
  collect = TRUE, confint = TRUE, level = 0.95,
  check_estimability = FALSE, ddf = c("Satterthwaite", "Kenward-Roger",
  "lme4"), ...)
}
\arguments{
\item{model}{a model object fitted with \code{lmer} from package
\pkg{lmerTest}, i.e., an object of class \code{\link{lmerModLmerTest}}.}

\item{L}{a contrast vector or matrix or a list of these.
The \code{length}/\code{ncol} of each contrasts should equal
\code{length(fixef(model))}.}

\item{rhs}{right-hand-side of the statistical test, i.e. the hypothesized
value (a numeric scalar).}

\item{joint}{make an F-test of potentially several contrast vectors? If
\code{FALSE} single DF t-tests are applied to each vector or each row of
contrasts matrices.}

\item{collect}{collect list of tests in a matrix?}

\item{confint}{include columns for lower and upper confidence limits? Applies
when \code{joint} is \code{FALSE}.}

\item{level}{confidence level.}

\item{check_estimability}{check estimability of contrasts? Only single DF
contrasts are checked for estimability thus requiring \code{joint = FALSE} to
take effect. See details section for necessary adjustments to \code{L} when
estimability is checked with rank deficient design matrices.}

\item{ddf}{the method for computing the denominator degrees of freedom.
\code{ddf="Kenward-Roger"} uses Kenward-Roger's method.}

\item{...}{passed to \code{\link{contestMD}}.}
}
\value{
a \code{data.frame} or a list of \code{data.frame}s.
}
\description{
Tests of vector or matrix contrasts for \code{\link{lmer}} model fits.
}
\details{
If the design matrix is rank deficient, \code{lmer} drops columns for the
aliased coefficients from the design matrix and excludes the corresponding
aliased coefficients from \code{fixef(model)}. When estimability is checked
the original rank-deficient design matrix is recontructed and therefore
\code{L} contrast vectors need to include elements for the aliased
coefficients. Similarly when \code{L} is a matrix, its number of columns
needs to match that of the reconstructed rank-deficient design matrix.
}
\examples{

data("sleepstudy", package="lme4")
fm <- lmer(Reaction ~ Days + I(Days^2) + (1|Subject) + (0+Days|Subject),
           sleepstudy)
# F-test of third coeffcients - I(Days^2):
contest(fm, c(0, 0, 1))
# Equivalent t-test:
contest(fm, L=c(0, 0, 1), joint=FALSE)
# Test of 'Days + I(Days^2)':
contest(fm, L=diag(3)[2:3, ])
# Other options:
contest(fm, L=diag(3)[2:3, ], joint=FALSE)
contest(fm, L=diag(3)[2:3, ], joint=FALSE, collect=FALSE)

# Illustrate a list argument:
L <- list("First"=diag(3)[3, ], "Second"=diag(3)[-1, ])
contest(fm, L)
contest(fm, L, collect = FALSE)
contest(fm, L, joint=FALSE, confint = FALSE)
contest(fm, L, joint=FALSE, collect = FALSE, level=0.99)

# Illustrate testing of estimability:
# Consider the 'cake' dataset with a missing cell:
data("cake", package="lme4")
cake$temperature <- factor(cake$temperature, ordered=FALSE)
cake <- droplevels(subset(cake, temperature \%in\% levels(cake$temperature)[1:2] &
                            !(recipe == "C" & temperature == "185")))
with(cake, table(recipe, temperature))
fm <- lmer(angle ~ recipe * temperature + (1|recipe:replicate), cake)
fixef(fm)
# The coefficient for recipeC:temperature185 is dropped:
attr(model.matrix(fm), "col.dropped")
# so any contrast involving this coefficient is not estimable:
Lmat <- diag(6)
contest(fm, Lmat, joint=FALSE, check_estimability = TRUE)

}
\seealso{
\code{\link[=contestMD.lmerModLmerTest]{contestMD}} for multi
degree-of-freedom contrast tests,
and \code{\link[=contest1D.lmerModLmerTest]{contest1D}} for tests of
1-dimensional contrasts.
}
\author{
Rune Haubo B. Christensen
}
