% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merPlots.R
\name{plotFEsim}
\alias{plotFEsim}
\title{Plot the results of a simulation of the fixed effects}
\usage{
plotFEsim(data, level = 0.95, stat = "median", sd = TRUE,
  intercept = FALSE, sigmaScale = NULL, oddsRatio = FALSE)
}
\arguments{
\item{data}{a data.frame generated by \code{\link{FEsim}} with simulations of
the fixed effects of a \code{\link{merMod}}}

\item{level}{the width of the confidence interval}

\item{stat}{a character value indicating the variable name in data of the
midpoint of the estimated interval, e.g. "mean" or "median"}

\item{sd}{logical, indicating whether or not to plot error bars around
the estimates (default is TRUE). Calculates the width of the error bars
based on \code{level} and the variable named "sd" in \code{data}}

\item{intercept}{logical, should the intercept be included, default is FALSE}

\item{sigmaScale}{a numeric value to divide the estimate and the standard
deviation by in the case of doing an effect size calculation}

\item{oddsRatio}{logical, should the parameters be converted to odds ratios
before plotting}
}
\value{
a ggplot2 plot of the coefficient effects
}
\description{
Plot the simulated fixed effects on a ggplot2 chart
}
\examples{
 fm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
 (p1 <- plotFEsim(FEsim(fm1)))
}
