% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{plot_sim_error_chks}
\alias{plot_sim_error_chks}
\title{Extract all warning msgs from a merMod object}
\usage{
plot_sim_error_chks(type = c("FE", "RE"), level = 0.95,
  stat = c("mean", "median"), sd = TRUE, sigmaScale = NULL,
  oddsRatio = FALSE, labs = FALSE, facet = TRUE)
}
\arguments{
\item{type}{check a fixed or random effect}

\item{level}{the width of the confidence interval}

\item{stat}{a character value indicating the variable name in data of the
midpoint of the estimated interval, e.g. "mean" or "median"}

\item{sd}{a logical indicating whether or not to plot error bars around
the estimates (default is TRUE). Calculates the width of the error bars
based on \code{level} and the variable named "sd" in \code{data}}

\item{sigmaScale}{a numeric value to divide the estimate and the standard
deviation by in the case of doing an effect size calculation}

\item{oddsRatio}{logical, should the parameters be converted to odds ratios
before plotting}

\item{labs}{logical, include the labels of the groups on the x-axis}

\item{facet}{Accepts either logical (\code{TRUE}) or \code{list} to specify which
random effects to plot. If \code{TRUE}, facets by both \code{groupFctr} and \code{term}.
If \code{list} selects the panel specified by the named elements of the list}
}
\description{
Extract all warning msgs from a merMod object
}
