% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packrat.R
\name{clean}
\alias{clean}
\title{Remove Packages from the Library}
\usage{
clean(
  packages = NULL,
  project = NULL,
  lib.loc = libDir(project),
  dry.run = FALSE,
  force = FALSE
)
}
\arguments{
\item{packages}{A set of package names to remove from the project. When
\code{NULL}, \code{\link{unused_packages}} is used to find packages
unused in the project.}

\item{project}{The project directory. Defaults to current working
directory.}

\item{lib.loc}{The library to clean. Defaults to the private package library
associated with the project directory.}

\item{dry.run}{Perform a dry run, returning records on which packages would
have been moved by the current clean action.}

\item{force}{Force package removal, even if they are still in use within the project?}
}
\description{
Remove packages from the given library.
}
\examples{
\dontrun{

# Get unused package records
unused_packages()

# Clean all unused packages
clean()

# Clean specific packages
clean("foo")

}
}
