% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitter-a.r
\name{splitter_a}
\alias{splitter_a}
\title{Split an array by .margins.}
\usage{
splitter_a(data, .margins = 1L, .expand = TRUE, .id = NA)
}
\arguments{
\item{data}{>1d data structure (matrix, data.frame or array)}

\item{.margins}{a vector giving the subscripts to split up \code{data} by.}

\item{.expand}{if splitting a dataframe by row, should output be 1d
(expand = FALSE), with an element for each row; or nd (expand = TRUE),
with a dimension for each variable.}

\item{.id}{names of the split label.
Pass \code{NULL} to avoid creation of split labels.
Omit or pass \code{NA} to use the default names
\code{"X1"}, \code{"X2"}, \ldots.
Otherwise, this argument must have the same length as
\code{.margins}.}
}
\value{
a list of lower-d slices, with attributes that record split details
}
\description{
Split a 2d or higher data structure into lower-d pieces based
}
\details{
This is the workhorse of the \code{a*ply} functions.  Given a >1 d
data structure (matrix, array, data.frame), it splits it into pieces
based on the subscripts that you supply.  Each piece is a lower dimensional
slice.

The margins are specified in the same way as \code{\link{apply}}, but
\code{splitter_a} just splits up the data, while \code{apply} also
applies a function and combines the pieces back together.  This function
also includes enough information to recreate the split from attributes on
the list of pieces.
}
\examples{
plyr:::splitter_a(mtcars, 1)
plyr:::splitter_a(mtcars, 2)

plyr:::splitter_a(ozone, 2)
plyr:::splitter_a(ozone, 3)
plyr:::splitter_a(ozone, 1:2)
}
\seealso{
Other splitter functions: 
\code{\link{splitter_d}()}
}
\concept{splitter functions}
\keyword{internal}
