% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_cpu_times}
\alias{ps_cpu_times}
\title{CPU times of the process}
\usage{
ps_cpu_times(p)
}
\arguments{
\item{p}{Process handle.}
}
\value{
Named real vector or length four: \code{user}, \code{system},
\code{children_user},  \code{children_system}. The last two are \code{NA} on
non-Linux systems.
}
\description{
All times are measured in seconds:
\itemize{
\item \code{user}: Amount of time that this process has been scheduled in user
mode.
\item \code{system}: Amount of time that this process has been scheduled in
kernel mode
\item \code{children_user}: On Linux, amount of time that this process's
waited-for children have been scheduled in user mode.
\item \code{children_system}: On Linux, Amount of time that this process's
waited-for children have been scheduled in kernel mode.
}
}
\details{
Throws a \code{zombie_process()} error for zombie processes.
}
\examples{
\dontshow{if (ps::ps_is_supported()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
p <- ps_handle()
p
ps_cpu_times(p)
proc.time()
\dontshow{\}) # examplesIf}
}
\seealso{
Other process handle functions: 
\code{\link{ps_children}()},
\code{\link{ps_cmdline}()},
\code{\link{ps_connections}()},
\code{\link{ps_create_time}()},
\code{\link{ps_cwd}()},
\code{\link{ps_environ}()},
\code{\link{ps_exe}()},
\code{\link{ps_handle}()},
\code{\link{ps_interrupt}()},
\code{\link{ps_is_running}()},
\code{\link{ps_kill}()},
\code{\link{ps_memory_info}()},
\code{\link{ps_name}()},
\code{\link{ps_num_fds}()},
\code{\link{ps_num_threads}()},
\code{\link{ps_open_files}()},
\code{\link{ps_pid}()},
\code{\link{ps_ppid}()},
\code{\link{ps_resume}()},
\code{\link{ps_send_signal}()},
\code{\link{ps_status}()},
\code{\link{ps_suspend}()},
\code{\link{ps_terminal}()},
\code{\link{ps_terminate}()},
\code{\link{ps_uids}()},
\code{\link{ps_username}()}
}
\concept{process handle functions}
