\name{factor.rotate}
\alias{factor.rotate}
\title{``Hand" rotate a factor loading matrix }
\description{Given a factor or components matrix, it is sometimes useful to do arbitrary rotations of particular pairs of variables.  This supplements the much more powerful rotation package GPArotation and is meant for specific requirements to do unusual rotations.
}
\usage{
factor.rotate(f, angle, col1=1, col2=2,plot=FALSE,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{f}{original loading matrix or a data frame  (can be output from a factor analysis function}
  \item{angle}{ angle (in degrees!) to rotate }
  \item{col1}{ column in factor matrix defining the first variable}
  \item{col2}{ column in factor matrix defining the second variable }
  \item{plot}{plot the original (unrotated) and rotated factors}
  \item{...}{parameters to pass to fa.plot}
  }
\details{Partly meant as a demonstration of how rotation works, factor.rotate is useful for those cases that require specific rotations that are not available in more advanced packages such as GPArotation.  If the plot option is set to TRUE, then the original axes are shown as dashed lines.

The rotation is in degrees counter clockwise.
}
\value{the resulting rotated matrix of loadings.
}
\references{ \url{https://personality-project.org/r/book} \cr }
\author{
Maintainer: William Revelle \email{revelle@northwestern.edu  }
}
\note{For a complete rotation package, see GPArotation }
\examples{
#using the Harman 24 mental tests, rotate the 2nd and 3rd factors 45 degrees
f4<- fa(Harman74.cor$cov,4,rotate="TRUE")
f4r45 <- factor.rotate(f4,45,2,3)
f4r90 <- factor.rotate(f4r45,45,2,3)
print(factor.congruence(f4,f4r45),digits=3) #poor congruence with original
print(factor.congruence(f4,f4r90),digits=3) #factor 2 and 3 have been exchanged and 3 flipped

#a graphic example
data(Harman23.cor)
f2 <- fa(Harman23.cor$cov,2,rotate="none")
op <- par(mfrow=c(1,2))
cluster.plot(f2,xlim=c(-1,1),ylim=c(-1,1),title="Unrotated ")
f2r <- factor.rotate(f2,-33,plot=TRUE,xlim=c(-1,1),ylim=c(-1,1),title="rotated -33 degrees")
op <- par(mfrow=c(1,1))

}
\keyword{ multivariate }% at least one, from doc/KEYWORDS
\keyword{ models }% __ONLY ONE__ keyword per line
