# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Report the version of Armadillo
#'
#' @details The version is defined by Armadillo in the header \code{arma_version.hpp}.
#' @param single A logical vector indicating whether a single return values is requested,
#' or a named vector with three elements \code{major}, \code{minor} and \code{patch}.
#' @return Depending on the value of \code{single}, either a single number describing
#' the Armadillo version or a named vector with three elements \code{major}, \code{minor}
#' and \code{patch}. The function \code{armadillo_version_typed} returns an S3 object
#' of classes \sQuote{package_version} and \sQuote{numeric_version} which offer comparison
#' and formatting operators.
#' @seealso Armadillo header file \code{arma_version.hpp}.
armadillo_version <- function(single) {
    .Call(`_RcppArmadillo_armadillo_version`, single)
}

#' @rdname armadillo_version
armadillo_version_typed <- function() {
    .Call(`_RcppArmadillo_armadillo_version_typed`)
}

#' @rdname armadillo_set_seed
armadillo_set_seed_random <- function() {
    invisible(.Call(`_RcppArmadillo_armadillo_set_seed_random`))
}

#' @title Set the Armadillo Random Number Generator to given or random value
#' @description Setter functions for the internal Armadillo random number generator
#' @param val The seed used to initialize Armadillo's random number generator.
#' @details
#' Armadillo can switch between two random number generator implementations depending
#' on the compilation standard used. Under normal circumstances RcppArmadillo will connect
#' Armadillo to the R random number generator which also implies that \code{set.seed()}
#' should be used from R. To use this function, one also needs to undefine \code{ARMA_RNG_ALT}
#' so that the Armadillo generators are used.
#' @return The function is invoked for its side effect and has no return value.
#' @note This has been found to not work as expected in \pkg{RStudio}
#' as its code also uses the system RNG library. You may have to either
#' not run within \pkg{RStudio} or change your code to use a different RNG such
#' as the one from R.
#' @seealso The R documentation on its RNGs all of which are accessible via \pkg{Rcpp}.
armadillo_set_seed <- function(val) {
    invisible(.Call(`_RcppArmadillo_armadillo_set_seed`, val))
}

#' Report (or Set) Maximum Number of OpenMP Threads
#'
#' @param n Number of threads to be set
#' @return For the getter, and on a system with OpenMP, the maximum
#' number of threads that OpenMP may be using and on systems without it,
#' one. The setter does not return a value.
armadillo_get_number_of_omp_threads <- function() {
    .Call(`_RcppArmadillo_armadillo_get_number_of_omp_threads`)
}

#' @rdname armadillo_get_number_of_omp_threads
armadillo_set_number_of_omp_threads <- function(n) {
    invisible(.Call(`_RcppArmadillo_armadillo_set_number_of_omp_threads`, n))
}

fastLm_impl <- function(X, y) {
    .Call(`_RcppArmadillo_fastLm_impl`, X, y)
}

