% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{armadillo_set_seed_random}
\alias{armadillo_set_seed_random}
\alias{armadillo_set_seed}
\title{Set the Armadillo Random Number Generator to given or random value}
\usage{
armadillo_set_seed_random()

armadillo_set_seed(val)
}
\arguments{
\item{val}{The seed used to initialize Armadillo's random number generator.}
}
\value{
The function is invoked for its side effect and has no return value.
}
\description{
Setter functions for the internal Armadillo random number generator
}
\details{
Armadillo can switch between two random number generator implementations depending
on the compilation standard used. Under normal circumstances RcppArmadillo will connect
Armadillo to the R random number generator which also implies that \code{set.seed()}
should be used from R. To use this function, one also needs to undefine \code{ARMA_RNG_ALT}
so that the Armadillo generators are used.
}
\note{
This has been found to not work as expected in \pkg{RStudio}
as its code also uses the system RNG library. You may have to either
not run within \pkg{RStudio} or change your code to use a different RNG such
as the one from R.
}
\seealso{
The R documentation on its RNGs all of which are accessible via \pkg{Rcpp}.
}
