% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/namespace.R
\name{namespace_roclet}
\alias{namespace_roclet}
\title{Roclet: make \code{NAMESPACE}}
\usage{
namespace_roclet()
}
\description{
This roclet automates the production of a \code{NAMESPACE} file, which controls
the functions imported and exported by your package, as described in
\href{https://cran.r-project.org/doc/manuals/r-release/R-exts.html}{Writing R extensions}.

The \code{NAMESPACE} is generated in two passes: the first generates only
import directives (because this can be computed without evaluating package
code), and the second generates everything (after the package has been
loaded).

See \code{vignette("namespace")} for details.
}
\examples{
# The most common namespace tag is @export, which declares that a function
# is part of the external interface of your package
#' @export
foofy <- function(x, y, z) {
}

# You'll also often find global imports living in a file called
# R/{package}-package.R.
#' @importFrom magrittr \%>\%
#' @import rlang
NULL
}
\seealso{
Other roclets: 
\code{\link{rd_roclet}()},
\code{\link{vignette_roclet}()}
}
\concept{roclets}
