% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_dataset.R
\name{getDataset}
\alias{getDataset}
\title{Get Dataset}
\usage{
getDataset(..., floatingPointNumbersEnabled = FALSE)
}
\arguments{
\item{...}{A \code{data.frame} or some data vectors defining the dataset.}

\item{floatingPointNumbersEnabled}{If \code{TRUE}, 
sample sizes can be specified as floating-point numbers 
(in general this only make sense for simulation purposes); \cr
by default \code{floatingPointNumbersEnabled = FALSE}, i.e., 
samples sizes defined as floating-point numbers will be truncated.}
}
\value{
Returns a \code{\link{Dataset}} object.
}
\description{
Creates a dataset object and returns it.
}
\details{
The different dataset types \code{DatasetMeans}, of \code{DatasetRates}, or  
\code{DatasetSurvival} can be created as follows:
\itemize{
  \item An element of \code{\link{DatasetMeans}} for one sample is created by \cr
    \code{getDataset(sampleSizes =, means =, stDevs =)} where \cr
    \code{sampleSizes}, \code{means}, \code{stDevs} are vectors with stagewise sample sizes, 
    means and standard deviations of length given by the number of available stages.
  \item An element of \code{\link{DatasetMeans}} for two samples is created by \cr
    \code{getDataset(sampleSizes1 =, sampleSizes2 =, means1 =, means2 =, } \cr
    \code{stDevs1 =, stDevs2 =)} where 
    \code{sampleSizes1}, \code{sampleSizes2}, \code{means1}, \code{means2}, 
    \code{stDevs1}, \code{stDevs2} are vectors with 
    stagewise sample sizes, means and standard deviations for the two treatment groups 
    of length given by the number of available stages.
  \item An element of \code{\link{DatasetRates}} for one sample is created by \cr
    \code{getDataset(sampleSizes =, events =)} where \code{sampleSizes}, \code{events} are vectors 
    with stagewise sample sizes and events of length given by the number of available stages.
  \item An element of \code{\link{DatasetRates}} for two samples is created by \cr
    \code{getDataset(sampleSizes1 =, sampleSizes2 =, events1 =, events2 =)} where 
    \code{sampleSizes1}, \code{sampleSizes2}, \code{events1}, \code{events2} 
    are vectors with stagewise sample sizes 
    and events  for the two treatment groups of length given by the number of available stages.
  \item An element of \code{\link{DatasetSurvival}} is created by \cr
    \code{getDataset(events =, logRanks =, allocationRatios =)} where 
    \code{events}, \code{logRanks}, and \code{allocation ratios} are the stagewise events, 
    (one-sided) logrank statistics, and allocation ratios. 
}
Prefix \code{overall[Capital case of first letter of variable name]...} for the variable 
names enables entering the overall results and calculates stagewise statistics.

Note that in survival design usually the overall events and logrank test statistics are provided
in the output, so \cr
\code{getDataset(overallEvents=, overallLogRanks =, overallAllocationRatios =)} \cr
is the usual command for entering survival data. Note also that for \code{overallLogranks} also the
z scores from a Cox regression can be used.

\code{n} can be used in place of \code{samplesizes}.
}
\examples{

# Create a Dataset of Means (one group):

datasetOfMeans <- getDataset(
	   n = c(22, 11, 22, 11),
	   means = c(1, 1.1, 1, 1),
	   stDevs = c(1, 2, 2, 1.3)
)
datasetOfMeans
datasetOfMeans$show(showType = 2)

datasetOfMeans <- getDataset(
	   overallSampleSizes = c(22, 33, 55, 66),
	   overallMeans = c(1.000, 1.033, 1.020, 1.017 ),
	   overallStDevs = c(1.00, 1.38, 1.64, 1.58)
)
datasetOfMeans
datasetOfMeans$show(showType = 2)
as.data.frame(datasetOfMeans)

# Create a Dataset of Means (two groups):

datasetOfMeans <- getDataset(
	   n1 = c(22, 11, 22, 11),
	   n2 = c(22, 13, 22, 13),
	   means1 = c(1, 1.1, 1, 1),
	   means2 = c(1.4, 1.5, 3, 2.5),
	   stDevs1 = c(1, 2, 2, 1.3),
	   stDevs2 = c(1, 2, 2, 1.3)
)
datasetOfMeans

datasetOfMeans <- getDataset(
	   overallSampleSizes1 = c(22, 33, 55, 66),
	   overallSampleSizes2 = c(22, 35, 57, 70),
	   overallMeans1 = c(1, 1.033, 1.020, 1.017),
	   overallMeans2 = c(1.4, 1.437, 2.040, 2.126),
	   overallStDevs1 = c(1, 1.38, 1.64, 1.58),
	   overallStDevs2 = c(1, 1.43, 1.82, 1.74)
)
datasetOfMeans

df <- data.frame(
	   stages = 1:4,
	   n1 = c(22, 11, 22, 11),
	   n2 = c(22, 13, 22, 13),
	   means1 = c(1, 1.1, 1, 1),
	   means2 = c(1.4, 1.5, 3, 2.5),
	   stDevs1 = c(1, 2, 2, 1.3),
	   stDevs2 = c(1, 2, 2, 1.3)
)
datasetOfMeans <- getDataset(df)
datasetOfMeans

## Create a Dataset of Rates (one group):

datasetOfRates <- getDataset(
	   n = c(8, 10, 9, 11), 
	   events = c(4, 5, 5, 6)
)
datasetOfRates

## Create a Dataset of Rates (two groups):

datasetOfRates <- getDataset(
	   n2 = c(8, 10, 9, 11),
	   n1 = c(11, 13, 12, 13),
	   events2 = c(3, 5, 5, 6),
	   events1 = c(10, 10, 12, 12)
)
datasetOfRates


## Create a Survival Dataset

dataset <- getDataset(
    overallEvents = c(8, 15, 19, 31),
	   overallAllocationRatios = c(1, 1, 1, 2),
	   overallLogRanks = c(1.52, 1.98, 1.99, 2.11)
)
dataset

}
