% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMI.R
\name{calculate.D2}
\alias{calculate.D2}
\title{Calculate the "D2" statistic}
\usage{
calculate.D2(w, DF = 0L, asymptotic = FALSE)
}
\arguments{
\item{w}{\code{numeric} vector of Wald \eqn{\chi^2} statistics. Can also
be Wald \emph{z} statistics, which will be internally squared to make
\eqn{\chi^2} statistics with one \emph{df} (must set \code{DF = 0L}).}

\item{DF}{degrees of freedom (\emph{df}) of the \eqn{\chi^2} statistics.
If \code{DF = 0L} (default), \code{w} is assumed to contain \emph{z}
statistics, which will be internally squared.}

\item{asymptotic}{\code{logical}. If \code{FALSE} (default), the pooled test
will be returned as an \emph{F}-distributed statistic with numerator
(\code{df1}) and denominator (\code{df2}) degrees of freedom.
If \code{TRUE}, the pooled \emph{F} statistic will be multiplied by its
\code{df1} on the assumption that its \code{df2} is sufficiently large
enough that the statistic will be asymptotically \eqn{\chi^2} distributed
with \code{df1}.}
}
\value{
A \code{numeric} vector containing the test statistic, \emph{df},
  its \emph{p} value, and 2 missing-data diagnostics: the relative invrease
  in variance (RIV, or average for multiparameter tests: ARIV) and the
  fraction missing information (FMI = ARIV / (1 + ARIV)).
}
\description{
This is a utility function used to calculate the "D2" statistic for pooling
test statistics across multiple imputations. This function is called by
several functions used for \code{\linkS4class{lavaan.mi}} objects, such as
\code{\link{lavTestLRT.mi}}, \code{\link{lavTestWald.mi}}, and
\code{\link{lavTestScore.mi}}. But this function can be used for any general
scenario because it only requires a vector of \eqn{\chi^2} statistics (one
from each imputation) and the degrees of freedom for the test statistic.
See Li, Meng, Raghunathan, & Rubin (1991) and Enders (2010, chapter 8) for
details about how it is calculated.
}
\examples{
## generate a vector of chi-squared values, just for example
DF <- 3 # degrees of freedom
M <- 20 # number of imputations
CHI <- rchisq(M, DF)

## pool the "results"
calculate.D2(CHI, DF) # by default, an F statistic is returned
calculate.D2(CHI, DF, asymptotic = TRUE) # asymptotically chi-squared

## generate standard-normal values, for an example of Wald z tests
Z <- rnorm(M)
calculate.D2(Z) # default DF = 0 will square Z to make chisq(DF = 1)
## F test is equivalent to a t test with the denominator DF


}
\references{
Enders, C. K. (2010). \emph{Applied missing data analysis}. New
  York, NY: Guilford.

  Li, K.-H., Meng, X.-L., Raghunathan, T. E., & Rubin, D. B. (1991).
  Significance levels from repeated \emph{p}-values with multiply-imputed
  data. \emph{Statistica Sinica, 1}(1), 65--92. Retrieved from
  \url{https://www.jstor.org/stable/24303994}
}
\seealso{
\code{\link{lavTestLRT.mi}}, \code{\link{lavTestWald.mi}},
  \code{\link{lavTestScore.mi}}
}
\author{
Terrence D. Jorgensen (University of Amsterdam;
  \email{TJorgensen314@gmail.com})
}
