% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{MULTIseqDemux}
\alias{MULTIseqDemux}
\title{Demultiplex samples based on classification method from MULTI-seq (McGinnis et al., bioRxiv 2018)}
\usage{
MULTIseqDemux(
  object,
  assay = "HTO",
  quantile = 0.7,
  autoThresh = FALSE,
  maxiter = 5,
  qrange = seq(from = 0.1, to = 0.9, by = 0.05),
  verbose = TRUE
)
}
\arguments{
\item{object}{Seurat object. Assumes that the specified assay data has been added}

\item{assay}{Name of the multiplexing assay (HTO by default)}

\item{quantile}{The quantile to use for classification}

\item{autoThresh}{Whether to perform automated threshold finding to define the best quantile. Default is FALSE}

\item{maxiter}{Maximum number of iterations if autoThresh = TRUE. Default is 5}

\item{qrange}{A range of possible quantile values to try if autoThresh = TRUE}

\item{verbose}{Prints the output}
}
\value{
A Seurat object with demultiplexing results stored at \code{object$MULTI_ID}
}
\description{
Identify singlets, doublets and negative cells from multiplexing experiments. Annotate singlets by tags.
}
\examples{
\dontrun{
object <- MULTIseqDemux(object)
}

}
\references{
\doi{10.1038/s41592-019-0433-8}
}
\concept{preprocessing}
