% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{subset.Seurat}
\alias{subset.Seurat}
\alias{subset}
\alias{[.Seurat}
\title{Subset \code{Seurat} Objects}
\usage{
\method{subset}{Seurat}(
  x,
  subset,
  cells = NULL,
  features = NULL,
  idents = NULL,
  return.null = FALSE,
  ...
)

\method{[}{Seurat}(x, i, j, ...)
}
\arguments{
\item{x}{A \code{\link{Seurat}} object}

\item{subset}{Logical expression indicating features/variables to keep}

\item{cells, j}{A vector of cell names or indices to keep}

\item{features, i}{A vector of feature names or indices to keep}

\item{idents}{A vector of identity classes to keep}

\item{return.null}{If no cells are requested, return a \code{NULL};
by default, throws an error}

\item{...}{Arguments passed to \code{\link{WhichCells}}}
}
\value{
\code{subset}: A subsetted \code{Seurat} object

\code{[}: object \code{x} with features \code{i} and cells \code{j}
}
\description{
Subset \code{Seurat} Objects
}
\examples{
# `subset` examples
subset(pbmc_small, subset = MS4A1 > 4)
subset(pbmc_small, subset = `DLGAP1-AS1` > 2)
subset(pbmc_small, idents = '0', invert = TRUE)
subset(pbmc_small, subset = MS4A1 > 3, slot = 'counts')
subset(pbmc_small, features = VariableFeatures(object = pbmc_small))

# `[` examples
pbmc_small[VariableFeatures(object = pbmc_small), ]
pbmc_small[, 1:10]

}
\seealso{
\code{\link{WhichCells}}

Seurat object, validity, and interaction methods
\code{\link{$.Seurat}()},
\code{\link{Seurat-class}},
\code{\link{Seurat-validity}},
\code{\link{[[.Seurat}()},
\code{\link{[[<-,Seurat}},
\code{\link{[[<-,Seurat,NULL}},
\code{\link{dim.Seurat}()},
\code{\link{dimnames.Seurat}()},
\code{\link{merge.Seurat}()},
\code{\link{names.Seurat}()}
}
\concept{seurat}
