% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shade.R
\name{warp}
\alias{warp}
\title{Shift colours between spaces}
\usage{
warp(x, space)
}
\arguments{
\item{x}{An R object which can be coerced to class \code{"shade"}.}

\item{space}{A string naming the new space.}
}
\value{
A new object of class \code{"shade"}.
}
\description{
This function shifts the current colour space of its arguments to the
specified space, returning a new object of class \code{"shade"}.
}
\details{
Valid names for spaces are currently those supported by the
\code{\link{convertColor}} function, namely ``sRGB'', ``Apple RGB'', ``CIE
RGB'', ``XYZ'', ``Lab'' and ``Luv''; plus ``RGB'' (which is treated as an
alias for ``sRGB''), ``HSV'', ``LCh'' and ``LMS''. Case is not significant.
}
\note{
LMS space, used for chromatic adaptation and simulating colour
  blindness, is not uniquely defined. Here we use the (linearised) Bradford
  transform, obtained by Lam (1985) and used widely in ICC colour profiles
  and elsewhere, to transform to and from CIE XYZ space.
  
  R uses the D65 standard illuminant as the reference white for the ``Lab''
  and ``Luv'' spaces.
}
\examples{
warp("red", "HSV")
}
\references{
Lam, K.M. (1985). Metamerism and colour constancy. PhD thesis, University of
Bradford.
}
\seealso{
\code{\link{convertColor}}
}
\author{
Jon Clayden <code@clayden.org>
}
