% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay.R
\name{delay}
\alias{delay}
\title{Execute R code after a specified number of milliseconds has elapsed}
\usage{
delay(ms, expr)
}
\arguments{
\item{ms}{The number of milliseconds to wait (1000 milliseconds = 1 second)
before running the expression.}

\item{expr}{The R expression to run after the specified number of milliseconds
has elapsed.}
}
\description{
You can use \code{delay} if you want to wait a specific amount of time before
running code.  This function can be used in combination with other \code{shinyjs}
functions, such as hiding or resetting an element in a few seconds, but it
can also be used with any code as long as it's used inside a Shiny app.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\examples{
if (interactive()) {
  library(shiny)
  shinyApp(
    ui = fluidPage(
      useShinyjs(),
      p(id = "text", "This text will disappear after 3 seconds"),
      actionButton("close", "Close the app in half a second")
    ),
    server = function(input, output) {
      delay(3000, hide("text"))
      observeEvent(input$close, {
        delay(500, stopApp())
      })
    }
  )
}
}
\seealso{
\code{\link[shinyjs]{useShinyjs}},
\code{\link[shinyjs]{runExample}}
}

