% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_df.R
\name{add_rows}
\alias{add_rows}
\alias{merge_df}
\title{Merge labelled data frames}
\usage{
add_rows(..., id = NULL)

merge_df(..., id = NULL)
}
\arguments{
\item{...}{Two or more data frames to be merged.}

\item{id}{Optional name for ID column that will be created to indicate the
source data frames for appended rows.}
}
\value{
A full joined data frame.
}
\description{
Merges (full join) data frames and preserve value and variable labels.
}
\details{
This function works like \code{\link[dplyr:bind]{dplyr::bind_rows()}}, but preserves
  variable and value label attributes. \code{add_rows()} row-binds all data
  frames in \code{...}, even if these have different numbers of columns.
  Non-matching columns will be column-bound and filled with \code{NA}-values
  for rows in those data frames that do not have this column.
  \cr \cr
  Value and variable labels are preserved. If matching columns have
  different value label attributes, attributes from first data frame
  will be used.
  \cr \cr
  \code{merge_df()} is an alias for \code{add_rows()}.
}
\examples{
library(dplyr)
data(efc)
x1 <- efc \%>\% select(1:5) \%>\% slice(1:10)
x2 <- efc \%>\% select(3:7) \%>\% slice(11:20)

mydf <- add_rows(x1, x2)
mydf
str(mydf)

\dontrun{
library(sjPlot)
view_df(mydf)}

x3 <- efc \%>\% select(5:9) \%>\% slice(21:30)
x4 <- efc \%>\% select(11:14) \%>\% slice(31:40)

mydf <- add_rows(x1, x2, x3, x4, id = "subsets")
mydf
str(mydf)

}
