% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxon_test.R
\name{wilcoxon_test}
\alias{wilcoxon_test}
\title{Wilcoxon rank sum test}
\usage{
wilcoxon_test(
  data,
  select = NULL,
  by = NULL,
  weights = NULL,
  mu = 0,
  alternative = "two.sided",
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{select}{Name(s) of the continuous variable(s) (as character vector)
to be used as samples for the test. \code{select} can be one of the following:
\itemize{
\item \code{select} can be used in combination with \code{by}, in which case \code{select} is
the name of the continous variable (and \code{by} indicates a grouping factor).
\item \code{select} can also be a character vector of length two or more (more than
two names only apply to \code{kruskal_wallis_test()}), in which case the two
continuous variables are treated as samples to be compared. \code{by} must be
\code{NULL} in this case.
\item If \code{select} select is of length \strong{two} and \code{paired = TRUE}, the two samples
are considered as \emph{dependent} and a paired test is carried out.
\item If \code{select} specifies \strong{one} variable and \code{by = NULL}, a one-sample test
is carried out (only applicable for \code{t_test()} and \code{wilcoxon_test()})
\item For \code{chi_squared_test()}, if \code{select} specifies \strong{one} variable and
both \code{by} and \code{probabilities} are \code{NULL}, a one-sample test against given
probabilities is automatically conducted, with equal probabilities for
each level of \code{select}.
}}

\item{by}{Name of the variable indicating the groups. Required if \code{select}
specifies only one variable that contains all samples to be compared in the
test. If \code{by} is not a factor, it will be coerced to a factor. For
\code{chi_squared_test()}, if \code{probabilities} is provided, \code{by} must be \code{NULL}.}

\item{weights}{Name of an (optional) weighting variable to be used for the test.}

\item{mu}{The hypothesized difference in means (for \code{t_test()}) or location
shift (for \code{wilcoxon_test()} and \code{mann_whitney_test()}). The default is 0.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}. See \code{?t.test}
and \code{?wilcox.test}.}

\item{...}{Additional arguments passed to \code{wilcox.test()} (for unweighted
tests, i.e. when \code{weights = NULL}).}
}
\value{
A data frame with test results. The function returns p and Z-values
as well as effect size r and group-rank-means.
}
\description{
This function performs Wilcoxon rank sum tests for one sample
or for two \emph{paired} (dependent) samples. For \emph{unpaired} (independent)
samples, please use the \code{mann_whitney_test()} function.

A Wilcoxon rank sum test is a non-parametric test for the null hypothesis
that two samples have identical continuous distributions. The implementation
in \code{wilcoxon_test()} is only used for \emph{paired}, i.e. \emph{dependent} samples. For
independent (unpaired) samples, use \code{mann_whitney_test()}.

\code{wilcoxon_test()} can be used for ordinal scales or when the continuous
variables are not normally distributed. For large samples, or approximately
normally distributed variables, the \code{t_test()} function can be used (with
\code{paired = TRUE}).
}
\section{Which test to use}{

The following table provides an overview of which test to use for different
types of data. The choice of test depends on the scale of the outcome
variable and the number of samples to compare.\tabular{lll}{
   \strong{Samples} \tab \strong{Scale of Outcome} \tab \strong{Significance Test} \cr
   1 \tab binary / nominal \tab \code{chi_squared_test()} \cr
   1 \tab continuous, not normal \tab \code{wilcoxon_test()} \cr
   1 \tab continuous, normal \tab \code{t_test()} \cr
   2, independent \tab binary / nominal \tab \code{chi_squared_test()} \cr
   2, independent \tab continuous, not normal \tab \code{mann_whitney_test()} \cr
   2, independent \tab continuous, normal \tab \code{t_test()} \cr
   2, dependent \tab binary (only 2x2) \tab \code{chi_squared_test(paired=TRUE)} \cr
   2, dependent \tab continuous, not normal \tab \code{wilcoxon_test()} \cr
   2, dependent \tab continuous, normal \tab \code{t_test(paired=TRUE)} \cr
   >2, independent \tab continuous, not normal \tab \code{kruskal_wallis_test()} \cr
   >2, independent \tab continuous,     normal \tab \code{datawizard::means_by_group()} \cr
   >2, dependent \tab continuous, not normal \tab \emph{not yet implemented} (1) \cr
   >2, dependent \tab continuous,     normal \tab \emph{not yet implemented} (2) \cr
}


(1) More than two dependent samples are considered as \emph{repeated measurements}.
For ordinal or not-normally distributed outcomes, these samples are
usually tested using a \code{\link[=friedman.test]{friedman.test()}}, which requires the samples
in one variable, the groups to compare in another variable, and a third
variable indicating the repeated measurements (subject IDs).

(2) More than two dependent samples are considered as \emph{repeated measurements}.
For normally distributed outcomes, these samples are usually tested using
a ANOVA for repeated measurements. A more sophisticated approach would
be using a linear mixed model.
}

\examples{
\dontshow{if (requireNamespace("coin")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(mtcars)
# one-sample test
wilcoxon_test(mtcars, "mpg")
# base R equivalent, we set exact = FALSE to avoid a warning
wilcox.test(mtcars$mpg ~ 1, exact = FALSE)

# paired test
wilcoxon_test(mtcars, c("mpg", "hp"))
# base R equivalent, we set exact = FALSE to avoid a warning
wilcox.test(mtcars$mpg, mtcars$hp, paired = TRUE, exact = FALSE)

# when `by` is specified, each group must be of same length
data(iris)
d <- iris[iris$Species != "setosa", ]
wilcoxon_test(d, "Sepal.Width", by = "Species")
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Bender, R., Lange, S., Ziegler, A. Wichtige Signifikanztests.
Dtsch Med Wochenschr 2007; 132: e24–e25
\item du Prel, J.B., Röhrig, B., Hommel, G., Blettner, M. Auswahl statistischer
Testverfahren. Dtsch Arztebl Int 2010; 107(19): 343–8
}
}
\seealso{
\itemize{
\item \code{\link[=t_test]{t_test()}} for parametric t-tests of dependent and independent samples.
\item \code{\link[=mann_whitney_test]{mann_whitney_test()}} for non-parametric tests of unpaired (independent)
samples.
\item \code{\link[=wilcoxon_test]{wilcoxon_test()}} for Wilcoxon rank sum tests for non-parametric tests
of paired (dependent) samples.
\item \code{\link[=kruskal_wallis_test]{kruskal_wallis_test()}} for non-parametric tests with more than two
independent samples.
\item \code{\link[=chi_squared_test]{chi_squared_test()}} for chi-squared tests (two categorical variables,
dependent and independent).
}
}
