% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/susie_utils.R
\name{estimate_s_rss}
\alias{estimate_s_rss}
\title{Estimate s in \code{susie_rss} Model Using Regularized LD}
\usage{
estimate_s_rss(z, R, r_tol = 1e-08, method = "null-mle")
}
\arguments{
\item{z}{A p-vector of z scores.}

\item{R}{A p by p symmetric, positive semidefinite correlation
matrix.}

\item{r_tol}{Tolerance level for eigenvalue check of positive
semidefinite matrix of R.}

\item{method}{a string specifies the method to estimate \eqn{s}.}
}
\value{
A number between 0 and 1.
}
\description{
The estimated s gives information about the
  consistency between the z scores and LD matrix. A larger \eqn{s}
  means there is a strong inconsistency between z scores and LD
  matrix. The \dQuote{null-mle} method obtains mle of \eqn{s} under
  \eqn{z | R ~ N(0,(1-s)R + s I)}, \eqn{0 < s < 1}. The
  \dQuote{null-partialmle} method obtains mle of \eqn{s} under
  \eqn{U^T z | R ~ N(0,s I)}, in which \eqn{U} is a matrix containing
  the of eigenvectors that span the null space of R; that is, the
  eigenvectors corresponding to zero eigenvalues of R. The estimated
  \eqn{s} from \dQuote{null-partialmle} could be greater than 1. The
  \dQuote{null-pseudomle} method obtains mle of \eqn{s} under
  pseudolikelihood \eqn{L(s) = \prod_{j=1}^{p} p(z_j | z_{-j}, s,
  R)}, \eqn{0 < s < 1}.
}
\examples{
set.seed(1)
n = 500
p = 1000
beta = rep(0,p)
beta[1:4] = 0.01
X = matrix(rnorm(n*p),nrow = n,ncol = p)
X = scale(X,center = TRUE,scale = TRUE)
y = drop(X \%*\% beta + rnorm(n))
input_ss = compute_suff_stat(X,y,standardize = TRUE)
ss = univariate_regression(X,y)
R = cor(X)
attr(R,"eigen") = eigen(R, symmetric = TRUE)
zhat = with(ss,betahat/sebetahat)
s = estimate_s_rss(zhat, R)

}
