% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_graphs}
\alias{create_graphs}
\alias{create_ring}
\alias{create_path}
\alias{create_chordal_ring}
\alias{create_de_bruijn}
\alias{create_empty}
\alias{create_bipartite}
\alias{create_citation}
\alias{create_complete}
\alias{create_notable}
\alias{create_kautz}
\alias{create_lattice}
\alias{create_star}
\alias{create_tree}
\title{Create different types of well-defined graphs}
\usage{
create_ring(n, directed = FALSE, mutual = FALSE)

create_path(n, directed = FALSE, mutual = FALSE)

create_chordal_ring(n, w)

create_de_bruijn(alphabet_size, label_size)

create_empty(n, directed = FALSE)

create_bipartite(n1, n2, directed = FALSE, mode = "out")

create_citation(n)

create_complete(n)

create_notable(name)

create_kautz(alphabet_size, label_size)

create_lattice(dim, directed = FALSE, mutual = FALSE, circular = FALSE)

create_star(n, directed = FALSE, mutual = FALSE, mode = "out")

create_tree(n, children, directed = TRUE, mode = "out")
}
\arguments{
\item{n, n1, n2}{The number of nodes in the graph}

\item{directed}{Should the graph be directed}

\item{mutual}{Should mutual edges be created in case of the graph being
directed}

\item{w}{A matrix specifying the additional edges in the chordan ring. See
\code{\link[igraph:make_chordal_ring]{igraph::make_chordal_ring()}}}

\item{alphabet_size}{The number of unique letters in the alphabet used for
the graph}

\item{label_size}{The number of characters in each node}

\item{mode}{In case of a directed, non-mutual, graph should the edges flow
\code{'out'} or \code{'in'}}

\item{name}{The name of a notable graph. See a complete list in \code{\link[igraph:make_graph]{igraph::make_graph()}}}

\item{dim}{The dimensions of the lattice}

\item{circular}{Should each dimension in the lattice wrap around}

\item{children}{The number of children each node has in the tree (if possible)}
}
\value{
A tbl_graph
}
\description{
These functions creates a long list of different types of well-defined graphs,
that is, their structure is not based on any randomisation. All of these
functions are shallow wrappers around a range of \verb{igraph::make_*} functions
but returns \code{tbl_graph} rather than \code{igraph} objects.
}
\section{Functions}{
\itemize{
\item \code{create_ring()}: Create a simple ring graph

\item \code{create_path()}: Create a simple path

\item \code{create_chordal_ring()}: Create a chordal ring

\item \code{create_de_bruijn()}: Create a de Bruijn graph with the specified alphabet and label size

\item \code{create_empty()}: Create a graph with no edges

\item \code{create_bipartite()}: Create a full bipartite graph

\item \code{create_citation()}: Create a full citation graph

\item \code{create_complete()}: Create a complete graph (a graph where all nodes are connected)

\item \code{create_notable()}: Create a graph based on its name. See \code{\link[igraph:make_graph]{igraph::make_graph()}}

\item \code{create_kautz()}: Create a Kautz graph with the specified alphabet and label size

\item \code{create_lattice()}: Create a multidimensional grid of nodes

\item \code{create_star()}: Create a star graph (A single node in the center connected to all other nodes)

\item \code{create_tree()}: Create a tree graph

}}
\examples{
# Create a complete graph with 10 nodes
create_complete(10)

}
