% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmbroot.R
\name{tmbroot}
\alias{tmbroot}
\title{Compute likelihood profile confidence intervals of a TMB object by root-finding}
\usage{
tmbroot(obj, name, target = 0.5 * qchisq(0.95, df = 1), lincomb,
  parm.range = c(NA, NA), sd.range = 7, trace = FALSE,
  continuation = FALSE)
}
\arguments{
\item{obj}{Object from \code{MakeADFun} that has been optimized.}

\item{name}{Name or index of a parameter to profile.}

\item{target}{desired deviation from minimum log-likelihood. Default
is set to retrieve the 95% likelihood profile confidence interval,
if the objective function is a negative log-likelihood function}

\item{lincomb}{Optional linear combination of parameters to
profile. By default a unit vector corresponding to \code{name}.}

\item{parm.range}{lower and upper limits; if \code{NA},
a value will be guessed based on the parameter value and \code{sd.range}}

\item{sd.range}{in the absence of explicit \code{parm.range} values,
the range chosen will be the parameter value plus or minus \code{sd.range}
times the corresponding standard deviation.
May be specified as a two-element vector for different ranges below and
above the parameter value.}

\item{trace}{report information?}

\item{continuation}{use continuation method, i.e. set starting parameters for non-focal parameters to solutions from previous fits?}
}
\value{
a two-element numeric vector containing the lower and upper limits (or \code{NA} if the target is not achieved in the range), with an attribute giving the total number of function iterations used
}
\description{
Compute likelihood profile confidence intervals of a TMB object by root-finding
in contrast to \code{\link{tmbprofile}}, which tries to compute
somewhat equally spaced values along the likelihood profile (which
is useful for visualizing the shape of the likelihood surface),
and then (via \code{\link{confint.tmbprofile}}) extracting a
critical value by linear interpolation,
}
\examples{
\dontrun{
runExample("simple",thisR=TRUE)
logsd0.ci <- tmbroot(obj,"logsd0")
}
}
