% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{UnhandledHTTPRequestError}
\alias{UnhandledHTTPRequestError}
\title{UnhandledHTTPRequestError}
\description{
Handle http request errors
}
\details{
How this error class is used:
If \code{record="once"} we trigger this.

Users can use vcr in the context of both use_cassette
and insert_cassette.

For the former, all requests go through the call_block
But for the latter, requests go through webmockr

Where is one place where we can put UnhandledHTTPRequestError
that will handle both use_cassette and insert_cassette?
}
\section{Error situations where this is invoked}{

\itemize{
\item record=once AND there's a new request that doesn't match
the one in the cassette on disk
\itemize{
\item in webmockr: if no stub found and there are recorded
interactions on the cassette, and record = once, then
error with UnhandledHTTPRequestError
\itemize{
\item but if record != once, then allow it, unless record == none
}
}
\item others?
}
}

\examples{
vcr_configure(dir = tempdir())
cassettes()
insert_cassette("turtle")
request <- Request$new("post", 'https://eu.httpbin.org/post?a=5',
  "", list(foo = "bar"))

err <- UnhandledHTTPRequestError$new(request)
err$request_description()
err$current_matchers()
err$match_request_on_headers()
err$match_request_on_body()
err$formatted_headers()
cat(err$formatted_headers(), "\n")
cat(err$cassettes_description(), "\n")
cat(err$cassettes_list(), "\n")
err$formatted_suggestions()
cat(err$format_bullet_point('foo bar', 1), "\n")
err$suggestion_for("use_new_episodes")
err$suggestions()
err$no_cassette_suggestions()
err$record_mode_suggestion()
err$has_used_interaction_matching()
err$match_requests_on_suggestion()

# err$construct_message()

# cleanup
unlink(tempdir())
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{request}}{a \link{Request} object}

\item{\code{cassette}}{a cassette name}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{UnhandledHTTPRequestError$new()}}
\item \href{#method-run}{\code{UnhandledHTTPRequestError$run()}}
\item \href{#method-construct_message}{\code{UnhandledHTTPRequestError$construct_message()}}
\item \href{#method-request_description}{\code{UnhandledHTTPRequestError$request_description()}}
\item \href{#method-current_matchers}{\code{UnhandledHTTPRequestError$current_matchers()}}
\item \href{#method-match_request_on_headers}{\code{UnhandledHTTPRequestError$match_request_on_headers()}}
\item \href{#method-match_request_on_body}{\code{UnhandledHTTPRequestError$match_request_on_body()}}
\item \href{#method-formatted_headers}{\code{UnhandledHTTPRequestError$formatted_headers()}}
\item \href{#method-cassettes_description}{\code{UnhandledHTTPRequestError$cassettes_description()}}
\item \href{#method-cassettes_list}{\code{UnhandledHTTPRequestError$cassettes_list()}}
\item \href{#method-formatted_suggestions}{\code{UnhandledHTTPRequestError$formatted_suggestions()}}
\item \href{#method-format_bullet_point}{\code{UnhandledHTTPRequestError$format_bullet_point()}}
\item \href{#method-format_foot_note}{\code{UnhandledHTTPRequestError$format_foot_note()}}
\item \href{#method-suggestion_for}{\code{UnhandledHTTPRequestError$suggestion_for()}}
\item \href{#method-suggestions}{\code{UnhandledHTTPRequestError$suggestions()}}
\item \href{#method-no_cassette_suggestions}{\code{UnhandledHTTPRequestError$no_cassette_suggestions()}}
\item \href{#method-record_mode_suggestion}{\code{UnhandledHTTPRequestError$record_mode_suggestion()}}
\item \href{#method-has_used_interaction_matching}{\code{UnhandledHTTPRequestError$has_used_interaction_matching()}}
\item \href{#method-match_requests_on_suggestion}{\code{UnhandledHTTPRequestError$match_requests_on_suggestion()}}
\item \href{#method-clone}{\code{UnhandledHTTPRequestError$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{UnhandledHTTPRequestError} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$new(request, cassette)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{(Request) a \link{Request} object}

\item{\code{cassette}}{(character) a cassette name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{UnhandledHTTPRequestError} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\subsection{Method \code{run()}}{
Run unhandled request handling
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$run()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
various
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-construct_message"></a>}}
\subsection{Method \code{construct_message()}}{
Construct and execute stop message for why request failed
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$construct_message()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a stop message
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-request_description"></a>}}
\subsection{Method \code{request_description()}}{
construct request description
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$request_description()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-current_matchers"></a>}}
\subsection{Method \code{current_matchers()}}{
get current request matchers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$current_matchers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-match_request_on_headers"></a>}}
\subsection{Method \code{match_request_on_headers()}}{
are headers included in current matchers?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$match_request_on_headers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-match_request_on_body"></a>}}
\subsection{Method \code{match_request_on_body()}}{
is body includled in current matchers?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$match_request_on_body()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-formatted_headers"></a>}}
\subsection{Method \code{formatted_headers()}}{
get request headers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$formatted_headers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cassettes_description"></a>}}
\subsection{Method \code{cassettes_description()}}{
construct description of current or lack thereof cassettes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$cassettes_description()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cassettes_list"></a>}}
\subsection{Method \code{cassettes_list()}}{
cassette details
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$cassettes_list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-formatted_suggestions"></a>}}
\subsection{Method \code{formatted_suggestions()}}{
make suggestions for what to do
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$formatted_suggestions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format_bullet_point"></a>}}
\subsection{Method \code{format_bullet_point()}}{
add bullet point to beginning of a line
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$format_bullet_point(lines, index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lines}}{(character) vector of strings}

\item{\code{index}}{(integer) a number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format_foot_note"></a>}}
\subsection{Method \code{format_foot_note()}}{
make a foot note
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$format_foot_note(url, index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{(character) a url}

\item{\code{index}}{(integer) a number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-suggestion_for"></a>}}
\subsection{Method \code{suggestion_for()}}{
get a suggestion by key
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$suggestion_for(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{(character) a character string}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-suggestions"></a>}}
\subsection{Method \code{suggestions()}}{
get all suggestions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$suggestions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-no_cassette_suggestions"></a>}}
\subsection{Method \code{no_cassette_suggestions()}}{
get all no cassette suggestions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$no_cassette_suggestions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-record_mode_suggestion"></a>}}
\subsection{Method \code{record_mode_suggestion()}}{
get the appropriate record mode suggestion
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$record_mode_suggestion()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-has_used_interaction_matching"></a>}}
\subsection{Method \code{has_used_interaction_matching()}}{
are there any used interactions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$has_used_interaction_matching()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-match_requests_on_suggestion"></a>}}
\subsection{Method \code{match_requests_on_suggestion()}}{
match requests on suggestion
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$match_requests_on_suggestion()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnhandledHTTPRequestError$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
