% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disease2biologicalprocess.R
\name{disease2biologicalprocess}
\alias{disease2biologicalprocess}
\title{Query for a disease or a list of diseases and generates an \code{DataGeNET.RDF}}
\usage{
disease2biologicalprocess(
  disease,
  vocabulary = "umls",
  database = "CURATED",
  score = c(0, 1),
  verbose = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{disease}{a CUI or a vector of CUIs}

\item{database}{Name of the database that will be queried.
It can take the values \code{'CTD_human'} to use Comparative
Toxicogenomics Database, human data; \code{'UNIPROT'} to use Universal
Protein Resource;\code{'CLINVAR'} to use ClinVar, a public archive of relationships
among sequence variation and human phenotype; \code{'GWASCAT'} to use
the NHGRI-EBI GWAS Catalog; \code{'ORPHANET'}, to use
Orphanet, the portal for rare diseases and orphan drugs;
\code{'CURATED'} to use expert curated, human databases;
\code{'RGD'}, to use Rat Genome Database; \code{'MGD'}, to use the Mouse Genome Database;
\code{'CTD_rat'} to use Comparative Toxicogenomics Database, rat data;
\code{'CTD_mouse'} to use Comparative Toxicogenomics Database, mouse data;
\code{'PREDICTED'} to use the expert curated, animal models data;
\code{'ALL'} to use all these databases. Default \code{'CURATED'}.}

\item{score}{A vector with two elements: 1) character with greather
\code{'>'} or with lower \code{'<'} meaing greather or equal and lower or
equal; 2) the score to be compared. By default: \code{c('>', 0)}.}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get a
on-time log from the function.}

\item{warnings}{By default \code{TRUE}. Change it to \code{FALSE} to don't see
the warnings.}
}
\value{
An object of class \code{DataGeNET.RDF}
}
\description{
Given a disease or a list of diseases, retrieves the GO BP of the gene products
associated to the disease(s) and creates an object of type \code{DataGeNET.RDF}.
}
\examples{
disease2bp <- disease2biologicalprocess( disease = "C1859062" )
}
