# Announce: Rakudo compiler, Release #153 (2022.02)

On behalf of the Rakudo development team, I’m very happy to announce the
February 2022 release of Rakudo #153. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2022.02:

+ Deprecations:

+ Additions:
    + Add support for $RAKUDO_OPT environment variable [e82e6774]
    + Implement sub rotor [90a04ac0]
    + Introducing $*RAT-UPGRADE-CLASS (#4299) [f737b080]
    + Add Cool.Order "coercer" (#4473) [4b2fc66f]
    + Add CI job that runs a spectest instead of Rakudo tests [7ef7b6ed]
    + Add :slip named argument to roundrobin() [de605e84]
    + Add an Any(iterable).infer method (#4626) [4d263779]
    + Add ACCEPTS candidate for Junction to Bool [f21af28e]
    + Add missing checks for nulls [821195b2]
    + Add missing precedence info for some infix ops (#4725) [cd86606e]
    + Add .unique to native arrays [bc8c286f]
    + Add .repeated to native arrays [369093c8]
    + Add .squish to native arrays [284b5623]
    + Finally add in memoriam for David Adler [510c24ed]

+ Removals:
    + Remove uniprop-(int|str|bool) [cc5f17a0] [2b355dc4]
    + Remove check for nullness of descriptor [b2f0a9d2]
    + Remove some no longer needed CALL-MEs [25ca2064]
    + Remove RESTRICTED setting (#3965) [6a8fa2f4]
    + Remove two dummy parameters from (Fat)Rat coercer [6c765609]
    + Remove dead code from MoarVM and JVM extops [e912bf2e][1ba3fe04]
      [421dd982][969ae326]

+ Changes:
    + Relax cross-language revision role-class boundaries [d493a051]
    + Get rid of trailing ] and } when dd-ing typed arrays/hashes [49608021]
    + Adapt to nqp::radix(_I)? now returning # chars converted [4a3753fb]
    + Disallow creating Uni with out-of-range codepoints [c56c578c][ef35db06]
    + Make Complex.new about 30x as fast [586f2f3c]
    + Get IO::Path!SET-SELF below inlining limit [4f3ff580][efdc1a9e]
    + $x ** ±Inf is sometimes 0 (#4226) [03065e29]
    + Make dd output consistent for arrays and hashes [59929f0a]
    + Call .perl(:arglist) for Capture's list elements [27ede8cb]
    + Make class A does B{ } error more awesome [535e0151]
    + Make .WHY on role group delegate to default role [8f989d1a][d3e74427]
      [91e3c983]
    + Make set-env.sh script work on MacOS (#4704) [19696916]
    + Protect some typechecks with try [e3f22147][5f843222]
    + Make sure that subclasses of FatRat .raku correctly [d6e6afb0]
    + Make Rat.FatRat about 5x as fast [82afbbf0]
    + Rename Any.infer to Any.are [186bd0b0]
    + Bring Rational.floor/ceiling/round/Int below inlining limit [59ea71f7]
    + Reduce bytecode size of Array[TR].BIND-POS [daeb9915]
    + Make adverbless @a[iterable] about 2.5x as fast [30f1fba3]
    + Make adverbless @a[*] about 20% faster [8ac55c57]
    + Make the adverbless zen-slice (@a[]) a few percent faster [21829c33]
    + Make FatRat.Rat coercion about 6x as fast [2fe1bb85]
    + Bring down bytecode size of nativearray.splice helper [38648b4f]
    + Re-arrange Int.base a bit [4d78bc6a]
    + Make unsuccessful .first about 40% faster [ed99df18]
    + Extract failure creation into separate subs [7dc3add8]
    + Make Capture[n] (and thus $0, $1, ...) about 5x as fast [11c8f82a]
    + Implement smartmatch as a dispatcher [32401c47]
    + Set up nativeref types for unsigned integers [b70d1147]
    + Support primspec 10 for unsigned integers [b092cc6c]
    + Also check iscont_u when looking for native references [2509e183]
    + Support uints as their own argument kind in dispatch [c0fbd367]
    + Use unsigned ops when handling unsigned buffers [63b2b846]
    + New uint candidates for operators [4db92b18]
    + Switch to unsigned ops where appropriate [c38b6b42]
    + Unsigned versions of some iterators [56923c12]
    + uint versions of native arrays [1ef6001f]
    + Bring uint improvements to the JVM [27f3b719]
    + Introduce NYI as a sub (#4716) [94456edf]
    + Make Int.roll/pick act as (^Int).roll/pick on 6.e (#4695) [45090c91]
    + Make Int.roll/pick about 6x as fast in v6.e [6222a14c]
    + Make ^Int:D about 14x as fast [21ee1fa0]
    + Make creation of Int .. Int object about 14x as fast [8fbe6c0a]
    + Specify base of non base 10 invalid numbers (#4717) [522155d5]
    + Further improvements to smartmatch dispatcher [cd20a2bc][6148b75c]
      [abfb9f86][2486960b]
    + Do some better job optimizing Junction on RHS [6f925ea2][eba72f4b]
      [49955840]
    + Properly support uints in BUILDPLANs [a38bebec]
    + Don't assume "year" as unit [34455138]
    + Use proper unsigned ops for accessing multidim uint arrays [8777e923]
    + Use nqp::istype for nominalizable smartmatch [ef4abcc7]

+ Fixes:
    + Make ranges coerce LHS into a numeric if range boundaries are numeric
      [7f73dcbd][dd5fabf9]
    + Many improvements to smartmatching and given/when [d0f2690f][7f1189fe]
      [7554d733][80fbaadd][fedfd716][91ec1bbf][5855c1d5][6616440d][9f80771c]
      [966e77fe][a1bb638f][ed85bad6][6b828fe6]
    + Fix Map ACCEPTS by collapsing explicit junctions [87621e1a]
    + [JVM] Mention routine in error for wrong arity [522e49a7]
    + Fix the behaviour of Pair ~~ Pair (#4671) [026c51a0]
    + Additional fixes and improvements of smartmatch optimizations [2a3f61ef]
    + Don't use MVM_free if we didn't use MVM_malloc [1b5c0b95]
    + Fix Nil warning in dd [a8498e8a]
    + Fix dd for nameless things [95d60623]
    + Fix potential race condition in Proc::Async start [8321ce10]
    + Test return constraints for role implementors (#3249) [56b57f61]
    + Use simpler code for correct `.length` suggestions test (#4703)
      [9310799c]
    + Fix warning in Pod::To::Text signature processing (#3528) [36cee696]
    + Make sure rebuilds of native array will generate ok [21d988d1]
    + Make add_constant lookup setting symbols only [28b51238]
    + Make initialization of core dynamic variables threadsafe [768ebea7]
    + Fix is_array_type on roles [944debd3]
    + Fix writes to native arrays via [] returning arbitrary data [72ef4e4d]
    + Fix "This container does not reference a native unsigned integer"
      [3823f88c]
    + Fix "This container does not reference a native integer" in Blob/Buf
      [a64c2f55]
    + Fix CArray treating all native integers as signed [fee9e822]
    + Eliminate p6decontrv ops caused by *_u ops [e5b67c1d][b3a71fbc]
    + Fix custom-lib race (#4738) [dab9cd66]
    + Fix method put failing on junctions [e521c8e4]
    + Fix Attribute.(get|set)_value treating uints like str [382f2f10]
    + Add unsigned candidate of +^ (bitwise negation) prefix operator
      [ffa09ff6]
    + Fix "Invalid ....BUILDALL plan: 24" error [118a0c3d]
    + Fix Attribute treating all native integers as signed [753c173e]
    + Fix optimizations of smartmatches over subsets [d6fb1919][b9d8aa49]
    + Fix "container does not reference a native integer" in UnsignedBlob.STORE
      [14bacc24]
    + Fix "No registered operation handler for 'iseq_u'" [4e1a7721]
    + Fix NativeCall wrongly expecting signed integer for size_t rw args
      [c92833f3]
    + Fix UInt where block trying to unbox a Scalar [26215f20]
    + Fix "container does not reference a native integer" with mixed int/uint
      multidim array indexes [7cb21467]
    + Fix "container does not reference a native integer" in multi slice
      [e4a4a92f]
    + Allow for using uint and int as indexes in native array slice assignment
      [a35a7791]
    + Fix precomp file rename race condition [006a920c]
    + Fix X::Method::NotFound on my-classes [8edc6d88]

+ Internal:
    + Replace nqp::attrinited with a descriptor-based approach [425913dc]
      [c3448773][13522362][71f8981b][c76c1e64][80f122d1][f96048c1][b6135861]
      [bdb0cc23][c719eab8][cd585f9d][8f796f5b][28053bd2][43f4e8a5]


The following people contributed to this release:

Stefan Seifert, Vadim Belman, Daniel Green, Elizabeth Mattijsen,
Nicholas Clark, Christian Bartolomäus, JJ Merelo, Justin DeVuyst,
Will "Coke" Coleda, finanalyst, Tom Browder, Stéphane Payrard, Altai-man,
Jonathan Worthington, Richard Hainsworth, Daniel Sockwell, Patrick Böker,
Suman Khanal, raiph, Aleks-Daniel Jakimenko-Aleksejev, Geoffrey Broadwell,
Martin Kealey, Nick Logan, Rafael Schipiura, Samantha McVey, Steve Dondley,
Trevor Stone, Wenzel P. P. Peppmeyer, Will Coleda, jaffa4, moon-chilled,
rir

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2022 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#154), is tentatively scheduled for 2022-03-18.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
