// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralG2Production.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.peripheral {
  public class G2Production_4_0_0 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.G2Production:4.0.0", null);

    public G2Production_4_0_0(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public G2Production_4_0_0(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new G2Production_4_0_0 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new G2Production_4_0_0(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int SUCCESS = 0;

    public const int ERR_INVALID_PARAMS = 1;

    public const int ERR_NO_CONFIG_MODE = 2;

    public const int ERR_NO_DEVICE = 3;

    public const int ERR_OPERATION_FAILED = 4;

    public class ProgramSerialNumberResult {
      public int _ret_;
    }

    public ProgramSerialNumberResult programSerialNumber(string romcode, string serial) {
      var _parameters = new LightJson.JsonObject();
      _parameters["romcode"] = romcode;
      _parameters["serial"] = serial;

      var _result = RpcCall("programSerialNumber", _parameters);
      var _ret = new ProgramSerialNumberResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest programSerialNumber(string romcode, string serial, AsyncRpcResponse<ProgramSerialNumberResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return programSerialNumber(romcode, serial, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest programSerialNumber(string romcode, string serial, AsyncRpcResponse<ProgramSerialNumberResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["romcode"] = romcode;
        _parameters["serial"] = serial;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("programSerialNumber", _parameters,
        _result => {
          try {
            var _ret = new ProgramSerialNumberResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
