#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;

use lib 'lib';
use Database::Filter;

binmode( STDOUT, "utf8" );

my @test_cases = (
    { select_column => 'SolsaID',
      select_operator => 'starts',
      search_value => 'TEST' },
);

eval {
    local $\ = "\n";
    for my $case (@test_cases) {
        my $filter = Database::Filter->new( $case );
        my( $sql ) = $filter->filter->to_SQL;
        print "WHERE $sql";
    }
};
if( $@ ) {
    print STDERR $@;
}
