#! /bin/sh

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

TMP_DB_TABLE="tmp_TABLE_$$"

TMP_DB_NAME=$(cat tests/config/mysql.name)
TMP_DB_CONF=tests/config/mysql.cnf

export TMP_DB_NAME
export TMP_DB_TABLE

mysql --defaults-file=${TMP_DB_CONF} ${TMP_DB_NAME} <<END
    drop table if exists ${TMP_DB_TABLE};
    create table ${TMP_DB_TABLE} (
        id INTEGER PRIMARY KEY NOT NULL AUTO_INCREMENT,
        uuid CHAR(36) NOT NULL,
        SolsaID CHAR(12) NOT NULL UNIQUE
    );
    insert into ${TMP_DB_TABLE} values (1, 'uuid', 'XX-TEST-0001');
END

perl <<'END'
#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;
use Config::Auto;
use Data::Dumper;

use lib 'lib';
use Database;
use Database::Filter;

binmode( STDOUT, "utf8" );

$Data::Dumper::Sortkeys = 1;
$Data::Dumper::Indent   = 1;

my $mysql_cnf = Config::Auto::parse( 'tests/config/mysql.cnf' );

my $db_settings = {
    content_db => {
        DB       => $ENV{TMP_DB_NAME},
        engine   => 'mysql',
        user     => $mysql_cnf->{client}{user},
        password => $mysql_cnf->{client}{password},
    }
};

my $filter = Database::Filter->new( { filter => lc( $ENV{TMP_DB_TABLE} ) .
                                                '.solsaid = "XX-TEST-0001"' } );

my $db = Database->new( $db_settings );
$db->connect();

print Dumper $db->get_records( $ENV{TMP_DB_TABLE},
                               undef,
                               { filter => $filter } );
END

mysql --defaults-file=${TMP_DB_CONF} ${TMP_DB_NAME} <<END
    drop table ${TMP_DB_TABLE};
END
