#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "transport_dg2.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  string approx = (argc > 2) ? argv[2] : "P0";
  Float alpha   = (argc > 3) ? atof(argv[3]) : 1;
  Float w       = (argc > 4) ? atof(argv[4]) : 1e-2;
  space Th (omega, approx);
  trial phi(Th); test psi(Th);
  form ah = integrate (dot(u(w),grad_h(phi))*psi)
          + integrate ("boundary", max(0, -dot(u(w),normal()))*phi*psi)
          + integrate ("internal_sides", 
	 	- dot(u(w),normal())*jump(phi)*average(psi)
                + 0.5*alpha*abs(dot(u(w),normal()))*jump(phi)*jump(psi));
  field lh = integrate ("boundary", phi_exact(w)*max(0, -dot(u(w),normal()))*psi);
  solver sah (ah.uu());
  field phi_h(Th);
  phi_h.set_u() = sah.solve(lh.u());
  dout << catchmark("w")   << w << endl
       << catchmark("phi") << phi_h;
}
