///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// input qmg mesh files:
//
//   istream& operator >> (istream&, qmg&);
//
//   with some technical stuff with bison & flex
//
// author: Pierre.Saramito@imag.fr
//
// date: 27 august 2000
//
#include "rheolef/geo-qmg.h"
using namespace rheolef;
using namespace std;

static qmg *p_data = 0;
static unsigned int qmg_line_no = 1;
static unsigned int qmg_n_error = 0;

extern int qmg_lex() ;
void qmg_error (const char* msg)
{
        error_macro("qmg input:" << qmg_line_no << ": " << msg);
	qmg_n_error++;
}
#ifdef TO_CLEAN
extern "C" {
  int qmg_wrap () { return 1; }
}
#undef  yywrap
#define yywrap qmg_wrap
#endif // TO_CLEAN

/* AIX requires this to be the first thing in the file.  */
#ifndef __GNUC__
# if _RHEOLEF_HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
#pragma alloca
#  else
#   ifndef alloca /* predefined by HP cc +Olibcalls */
char *alloca ();
#   endif
#  endif
# endif
#endif

#include "geo-qmg-yacc.cc"

// avoid re-definition of YY_NULL within flex
#ifdef YY_NULL
#undef YY_NULL
#endif
#include "geo-qmg-lex.cc"

static yyFlexLexer input_qmg ;

int qmg_lex() { return input_qmg.yylex(); }

istream& 
rheolef::operator >> (istream& is, qmg& data)
{
	p_data = &data;
  	input_qmg = yyFlexLexer(&is);
	qmg_line_no = 1;
	qmg_n_error = 0;
	if (qmg_parse() != 0 || qmg_n_error != 0) {
            is.setstate (ios::badbit);
        }
	// set slists in the original input order
	p_data -> reverse();
	return is;
}
