!> FRUIT unit test framework helper subroutines.
!! Based on driver code auto-generated by FRUIT's Ruby pre-processor.

!! Copyright (c) 2017 Advanced Micro Devices, Inc. All rights reserved.
!!
!! Permission is hereby granted, free of charge, to any person obtaining a copy
!! of this software and associated documentation files (the "Software"), to deal
!! in the Software without restriction, including without limitation the rights
!! to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
!! copies of the Software, and to permit persons to whom the Software is
!! furnished to do so, subject to the following conditions:
!!
!! The above copyright notice and this permission notice shall be included in
!! all copies or substantial portions of the Software.
!!
!! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
!! IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
!! FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
!! AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
!! LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
!! OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
!! THE SOFTWARE.

module fruit_helpers

  use fruit
  implicit none

contains

  !> Invoke a test case sub-routine of a test suite, invoking the
  !! suite's setup sub-routine first, and its teardown sub-routine
  !! after. This sub-routine was abstracted out from "basket" code
  !! auto-generated by FRUIT's Ruby pre-processor.
  subroutine run_fruit_test_case(test_case,test_case_name, &
    setup,teardown,test_suite_name)
    interface
      subroutine test_case()
      end subroutine
    end interface
    character(*),intent(in) :: test_case_name
    interface
      subroutine setup()
      end subroutine
    end interface
    interface
      subroutine teardown()
      end subroutine
    end interface
    character(*),intent(in) :: test_suite_name

    call setup()
    write(*,'(/A,A,A,A)') 'Running: ',test_suite_name,':',test_case_name
    call set_unit_name(test_case_name)
    call run_test_case(test_case,test_case_name)
    if (.not. is_case_passed()) then
      call case_failed_xml(test_case_name,test_suite_name)
    else
      call case_passed_xml(test_case_name,test_suite_name)
    end if
    call teardown()
  end subroutine run_fruit_test_case

end module fruit_helpers
