/*
*  Rubrica
*  file: decoration.c
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>

#include "types.h"

enum {
  PIXBUF, 
  TEXT
};

// enable/disable combo box item if executable is/isn't found
static void enable_if_executable   (GtkCellLayout *cell_layout, 
				    GtkCellRenderer *cell,  
				    GtkTreeModel *tree_model, 
				    GtkTreeIter *iter, gpointer data);

void rubrica_themes_changed        (GtkIconTheme* theme, gpointer data);
void rubrica_themes_update_preview (GtkFileChooser *file_chooser, 
				    gpointer data);

/*
void 
rubrica_themes_changed(GtkIconTheme* theme, gpointer data)
{
  GSList *l = icons;
 
  theme = gtk_icon_theme_get_default();
  for (; l; l = l->next)
    {
      IconInfo *info = (IconInfo *) l->data;
      
      gtk_icon_theme_load_icon (theme, info->name, info->size, 0, NULL);
    }
}


GdkPixbuf* 
rubrica_themes_load_icon(const gchar* icon_name, gint icon_size)
{
  GdkPixbuf* pixbuf;
  GSList* l = icons;
  gboolean found = FALSE;
	
  pixbuf = gtk_icon_theme_load_icon (theme, icon_name, icon_size, 0, NULL);  
      
  g_signal_connect(theme, "changed", 
		   G_CALLBACK(rubrica_themes_changed), pixbuf);

  for (; l; l = l->next)
    {
      IconInfo *info = (IconInfo *) l->data;
      
      if (g_ascii_strcasecmp(info->name, icon_name) == 0)
	{
	  found = TRUE;
	  break;
	}
    }
  if (!found)
    {
      IconInfo* info;
      
      info = g_malloc0(sizeof(IconInfo));
      info->name = g_strdup(icon_name);
      info->size = icon_size;
      
      icons = g_slist_append(icons, info);
    }

  return pixbuf;
}
*/


void 
rubrica_themes_add_directory(const gchar *directory)
{
  GtkIconTheme* theme;

  theme = gtk_icon_theme_get_default();       
  gtk_icon_theme_append_search_path(theme, directory);  
}


/*  enable/disable combo box item if executable is/isn't found
*/
static void
enable_if_executable (GtkCellLayout *cell_layout, GtkCellRenderer *cell,  
		      GtkTreeModel *tree_model, GtkTreeIter *iter,
		      gpointer data)
{
  GtkTreePath *path;
  RubricaThemedItem* array = (RubricaThemedItem*) data;
  gint index;
  
  path = gtk_tree_model_get_path (tree_model, iter);
  index = gtk_tree_path_get_indices(path)[0];
  gtk_tree_path_free (path);

  if (array[index].exec)
    {
      gchar* executable;
      
      executable = g_find_program_in_path(array[index].exec);
      if(executable)
	g_object_set (cell, "sensitive", TRUE, NULL);  	
      else
	g_object_set (cell, "sensitive", FALSE, NULL);  
    }
  else
    g_object_set (cell, "sensitive", TRUE, NULL);  	
}


void 
theme_changed (GtkIconTheme *icon_theme, gpointer data) 
{
  GtkIconTheme* theme;
  GdkPixbuf*  pixbuf;
  gchar* icon = (gchar*) data;
  
  theme  = gtk_icon_theme_get_default(); 
  pixbuf = gtk_icon_theme_load_icon (theme, icon, 24, 0, NULL);  
}


void 
rubrica_themes_create_themed_list(GtkComboBox* combo, RubricaThemedItem* array)
{ 
  gint i = 0;
  GtkTreeModel *model;
  GtkTreeIter iter; 
  GtkIconTheme* theme;
  RubricaThemedItem* list = array;
  GtkCellRenderer  *cell;
  
  theme = gtk_icon_theme_get_default(); 
  model = (GtkTreeModel*) gtk_list_store_new(2, GDK_TYPE_PIXBUF, 
					     G_TYPE_STRING);
  gtk_combo_box_set_model(GTK_COMBO_BOX(combo), model);

  cell = gtk_cell_renderer_pixbuf_new ();
  gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (combo), cell, FALSE);
  gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (combo), cell, 
				  "pixbuf", PIXBUF, NULL);
  
  gtk_cell_layout_set_cell_data_func (GTK_CELL_LAYOUT (combo),
				      cell, enable_if_executable,
				      array, NULL);

  cell = gtk_cell_renderer_text_new ();
  gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (combo), cell, TRUE);
  gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (combo), cell, 
				  "text", TEXT, NULL);
  
  gtk_cell_layout_set_cell_data_func (GTK_CELL_LAYOUT (combo),
				      cell, enable_if_executable,
				      array, NULL);

  for (; list[i].label; i++)
    {
      GdkPixbuf*  pixbuf;
      
      pixbuf = gtk_icon_theme_load_icon (theme, list[i].icon, 24, 0, NULL);
	
      gtk_list_store_append(GTK_LIST_STORE(model), &iter);
      gtk_list_store_set(GTK_LIST_STORE(model), &iter,
			 PIXBUF, pixbuf, 
			 TEXT,   _(list[i].label), 
			 -1);

      g_signal_connect(G_OBJECT(theme), "changed", 
		       G_CALLBACK(theme_changed), list[i].icon);
    }

  g_object_unref(model);    
}



gchar*
rubrica_themes_load_pixmap(GtkWidget* button, gpointer data)
{
  GtkWidget *dialog;
  GtkImage *preview; 
  GtkImage *image = data;
  gchar* uri = NULL;

  preview = (GtkImage*) gtk_image_new();

  dialog = gtk_file_chooser_dialog_new ("Open File", NULL,
					GTK_FILE_CHOOSER_ACTION_OPEN,
					GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
					NULL);

  g_object_set_data(G_OBJECT(dialog), "image", image);
  gtk_file_chooser_set_preview_widget (GTK_FILE_CHOOSER (dialog),
				       (GtkWidget*) preview);

  g_signal_connect (GTK_FILE_CHOOSER (dialog), "update-preview",
		    G_CALLBACK (rubrica_themes_update_preview), preview);
  
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
      uri = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));

      g_object_set_data(G_OBJECT(button), "uri", uri);
   }
      
  gtk_widget_destroy (dialog);
  
  return uri;
}


void
rubrica_themes_update_preview (GtkFileChooser *file_chooser, gpointer data)
{
  GtkWidget *preview;
  GtkImage *image;
  char *filename;
  GdkPixbuf *pixbuf;
  gboolean have_preview;

  preview  = GTK_WIDGET (data);
  image    = g_object_get_data(G_OBJECT(file_chooser), "image");
  filename = gtk_file_chooser_get_preview_filename (file_chooser);

  if (filename)
    {
      pixbuf = gdk_pixbuf_new_from_file_at_size (filename, 24, 24, NULL);
      gtk_image_set_from_pixbuf (GTK_IMAGE (image), pixbuf);
      if (pixbuf)
	gdk_pixbuf_unref (pixbuf);

      pixbuf = gdk_pixbuf_new_from_file_at_size (filename, 48, 48, NULL);
      have_preview = (pixbuf != NULL);
      g_free (filename);

      gtk_image_set_from_pixbuf (GTK_IMAGE (preview), pixbuf);
      if (pixbuf)
	gdk_pixbuf_unref (pixbuf);
      
      gtk_file_chooser_set_preview_widget_active (file_chooser, have_preview);
    }
}




