# Summary

* [Getting Started](getting-started.md)
* [Tutorial: Guessing Game](guessing-game.md)
* [Syntax and Semantics](syntax-and-semantics.md)
    * [Variable Bindings](variable-bindings.md)
    * [Functions](functions.md)
    * [Primitive Types](primitive-types.md)
    * [Comments](comments.md)
    * [if](if.md)
    * [Loops](loops.md)
    * [Ownership](ownership.md)
    * [References and Borrowing](references-and-borrowing.md)
    * [Lifetimes](lifetimes.md)
    * [Mutability](mutability.md)
    * [Structs](structs.md)
    * [Enums](enums.md)
    * [Match](match.md)
    * [Patterns](patterns.md)
    * [Method Syntax](method-syntax.md)
    * [Vectors](vectors.md)
    * [Strings](strings.md)
    * [Generics](generics.md)
    * [Traits](traits.md)
    * [Drop](drop.md)
    * [if let](if-let.md)
    * [Trait Objects](trait-objects.md)
    * [Closures](closures.md)
    * [Universal Function Call Syntax](ufcs.md)
    * [Crates and Modules](crates-and-modules.md)
    * [`const` and `static`](const-and-static.md)
    * [Attributes](attributes.md)
    * [`type` aliases](type-aliases.md)
    * [Casting between types](casting-between-types.md)
    * [Associated Types](associated-types.md)
    * [Unsized Types](unsized-types.md)
    * [Operators and Overloading](operators-and-overloading.md)
    * [Deref coercions](deref-coercions.md)
    * [Macros](macros.md)
    * [Raw Pointers](raw-pointers.md)
    * [`unsafe`](unsafe.md)
* [Effective Rust](effective-rust.md)
    * [The Stack and the Heap](the-stack-and-the-heap.md)
    * [Testing](testing.md)
    * [Conditional Compilation](conditional-compilation.md)
    * [Documentation](documentation.md)
    * [Iterators](iterators.md)
    * [Concurrency](concurrency.md)
    * [Error Handling](error-handling.md)
    * [Choosing your Guarantees](choosing-your-guarantees.md)
    * [FFI](ffi.md)
    * [Borrow and AsRef](borrow-and-asref.md)
    * [Release Channels](release-channels.md)
    * [Using Rust without the standard library](using-rust-without-the-standard-library.md)
* [Nightly Rust](nightly-rust.md)
    * [Compiler Plugins](compiler-plugins.md)
    * [Inline Assembly](inline-assembly.md)
    * [No stdlib](no-stdlib.md)
    * [Intrinsics](intrinsics.md)
    * [Lang items](lang-items.md)
    * [Advanced linking](advanced-linking.md)
    * [Benchmark Tests](benchmark-tests.md)
    * [Box Syntax and Patterns](box-syntax-and-patterns.md)
    * [Slice Patterns](slice-patterns.md)
    * [Associated Constants](associated-constants.md)
    * [Custom Allocators](custom-allocators.md)
* [Glossary](glossary.md)
* [Syntax Index](syntax-index.md)
* [Bibliography](bibliography.md)
