/* rygel-playbin-player.c generated by valac 0.31.1.6-4f062, the Vala compiler
 * generated from rygel-playbin-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010,2011,2012 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH
 * Copyright (C) 2012,2013 Intel Corporation.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Neha Shanbhag <N.Shanbhag@cablelabs.com>
 *         Sivakumar Mani <siva@orexel.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-renderer.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gst/audio/audio.h>


#define RYGEL_PLAYBIN_TYPE_PLAYER (rygel_playbin_player_get_type ())
#define RYGEL_PLAYBIN_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer))
#define RYGEL_PLAYBIN_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))
#define RYGEL_PLAYBIN_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))

typedef struct _RygelPlaybinPlayer RygelPlaybinPlayer;
typedef struct _RygelPlaybinPlayerClass RygelPlaybinPlayerClass;
typedef struct _RygelPlaybinPlayerPrivate RygelPlaybinPlayerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__rygel_dlna_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__rygel_dlna_profile_unref0_ (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

typedef enum  {
	RYGEL_PLAYBIN_PLAYER_ERROR_NO_ELEMENT
} RygelPlaybinPlayerError;
#define RYGEL_PLAYBIN_PLAYER_ERROR rygel_playbin_player_error_quark ()
struct _RygelPlaybinPlayer {
	GObject parent_instance;
	RygelPlaybinPlayerPrivate * priv;
};

struct _RygelPlaybinPlayerClass {
	GObjectClass parent_class;
};

struct _RygelPlaybinPlayerPrivate {
	GstElement* _playbin;
	gchar* _playback_state;
	gchar** _allowed_playback_speeds;
	gint _allowed_playback_speeds_length1;
	gint __allowed_playback_speeds_size_;
	gchar* _new_playback_speed;
	gchar* _playback_speed;
	gchar* transfer_mode;
	gboolean uri_update_hint;
	gchar* _uri;
	gchar* _mime_type;
	gchar* _metadata;
	gchar* _user_agent;
	gchar* _content_features;
	GUPnPProtocolInfo* protocol_info;
	gint64 _parsed_duration;
	GList* _supported_profiles;
};


static gpointer rygel_playbin_player_parent_class = NULL;
static RygelPlaybinPlayer* rygel_playbin_player_player;
static RygelPlaybinPlayer* rygel_playbin_player_player = NULL;
static gboolean rygel_playbin_player_has_dlna_src;
static gboolean rygel_playbin_player_has_dlna_src = FALSE;
static RygelMediaPlayerIface* rygel_playbin_player_rygel_media_player_parent_iface = NULL;

GQuark rygel_playbin_player_error_quark (void);
GType rygel_playbin_player_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYBIN_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerPrivate))
enum  {
	RYGEL_PLAYBIN_PLAYER_DUMMY_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBIN,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE,
	RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED,
	RYGEL_PLAYBIN_PLAYER_URI,
	RYGEL_PLAYBIN_PLAYER_MIME_TYPE,
	RYGEL_PLAYBIN_PLAYER_METADATA,
	RYGEL_PLAYBIN_PLAYER_CAN_SEEK,
	RYGEL_PLAYBIN_PLAYER_CAN_SEEK_BYTES,
	RYGEL_PLAYBIN_PLAYER_USER_AGENT,
	RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES,
	RYGEL_PLAYBIN_PLAYER_VOLUME,
	RYGEL_PLAYBIN_PLAYER_DURATION,
	RYGEL_PLAYBIN_PLAYER_SIZE,
	RYGEL_PLAYBIN_PLAYER_POSITION,
	RYGEL_PLAYBIN_PLAYER_BYTE_POSITION,
	RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES
};
static void _rygel_dlna_profile_unref0_ (gpointer var);
static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING "Streaming"
#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE "Interactive"
#define RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE "http-get:%s:*:%s"
static RygelPlaybinPlayer* rygel_playbin_player_new (GError** error);
static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type, GError** error);
static void rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self, GstElement* value);
GstElement* rygel_playbin_player_get_playbin (RygelPlaybinPlayer* self);
static void rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self);
RygelPlaybinPlayer* rygel_playbin_player_instance (GError** error);
static gboolean rygel_playbin_player_seek_with_format (RygelPlaybinPlayer* self, GstFormat format, gint64 target);
static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, gint64 time);
static gboolean rygel_playbin_player_real_seek_bytes (RygelMediaPlayer* base, gint64 bytes);
static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self);
static inline GstCaps* _dynamic_get_caps0 (GstElement* obj);
static void rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message);
static inline gchar* _dynamic_get_current_uri1 (GstElement* obj);
static inline gchar* _dynamic_get_uri2 (GstElement* obj);
static gchar* rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self);
static void rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self, GstElement* pipeline, GstElement* source);
static inline void _dynamic_set_extra_headers3 (GstElement* obj, GstStructure* value);
static inline void _dynamic_set_user_agent4 (GstElement* obj, gchar* value);
static void rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self, GParamSpec* pspec);
static inline void _dynamic_set_auto_flush_bus5 (GstElement* obj, gboolean value);
static void _rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender, GstElement* source, gpointer self);
gulong _dynamic_source_setup1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static void _rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void rygel_playbin_player_guess_duration (RygelPlaybinPlayer* self);
static void __lambda4_ (RygelPlaybinPlayer* self, GUPnPDIDLLiteObject* object);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void ___lambda4__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self);
static gchar** _vala_array_dup3 (gchar** self, int length);
static inline void _dynamic_set_uri6 (GstElement* obj, gchar* value);
static inline void _dynamic_set_uri7 (GstElement* obj, const gchar* value);
static inline GstElement* _dynamic_get_source8 (GstElement* obj);
static inline GstElement* _dynamic_get_source9 (GstElement* obj);
static inline GstElement* _dynamic_get_source10 (GstElement* obj);
static inline GstElement* _dynamic_get_source11 (GstElement* obj);
GList* rygel_playbin_player_get_supported_profiles (RygelPlaybinPlayer* self);
static void rygel_playbin_player_finalize (GObject* obj);
static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* RYGEL_PLAYBIN_PLAYER_protocols[2] = {"http-get", "rtsp"};
static const gchar* RYGEL_PLAYBIN_PLAYER_mime_types[42] = {"audio/mpeg", "application/ogg", "audio/x-vorbis", "audio/x-vorbis+ogg", "audio/ogg", "audio/x-ms-wma", "audio/x-ms-asf", "audio/x-flac", "audio/x-flac+ogg", "audio/flac", "audio/mp4", "audio/3gpp", "audio/vnd.dlna.adts", "audio/x-mod", "audio/x-wav", "audio/x-ac3", "audio/x-m4a", "audio/l16;rate=44100;channels=2", "audio/l16;rate=44100;channels=1", "audio/l16;channels=2;rate=44100", "audio/l16;channels=1;rate=44100", "audio/l16;rate=44100", "image/jpeg", "image/png", "video/x-theora", "video/x-theora+ogg", "video/x-oggm", "video/ogg", "video/x-dirac", "video/x-wmv", "video/x-wma", "video/x-msvideo", "video/x-3ivx", "video/x-3ivx", "video/x-matroska", "video/x-mkv", "video/mpeg", "video/mp4", "application/x-shockwave-flash", "video/x-ms-asf", "video/x-xvid", "video/x-ms-wmv"};

GQuark rygel_playbin_player_error_quark (void) {
	return g_quark_from_static_string ("rygel_playbin_player_error-quark");
}


static void _rygel_dlna_profile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
}


static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _rygel_dlna_profile_unref0_, NULL);
	g_list_free (self);
}


static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type, GError** error) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = gst_element_factory_make ("playbin", NULL);
	if (_tmp0_ != NULL) {
		g_object_ref_sink (_tmp0_);
	}
	_tmp1_ = _tmp0_;
	rygel_playbin_player_set_playbin (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_playbin;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp3_ = _ ("Your GStreamer installation seems to be missing the \"playbin\" elemen" \
"t. The Rygel GStreamer renderer implementation cannot work without it");
		_tmp4_ = g_error_new_literal (RYGEL_PLAYBIN_PLAYER_ERROR, RYGEL_PLAYBIN_PLAYER_ERROR_NO_ELEMENT, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	rygel_playbin_player_setup_playbin (self);
	return self;
}


static RygelPlaybinPlayer* rygel_playbin_player_new (GError** error) {
	return rygel_playbin_player_construct (RYGEL_PLAYBIN_TYPE_PLAYER, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelPlaybinPlayer* rygel_playbin_player_instance (GError** error) {
	RygelPlaybinPlayer* result = NULL;
	RygelPlaybinPlayer* _tmp0_ = NULL;
	RygelPlaybinPlayer* _tmp4_ = NULL;
	RygelPlaybinPlayer* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_playbin_player_player;
	if (_tmp0_ == NULL) {
		RygelPlaybinPlayer* _tmp1_ = NULL;
		RygelPlaybinPlayer* _tmp2_ = NULL;
		RygelPlaybinPlayer* _tmp3_ = NULL;
		_tmp2_ = rygel_playbin_player_new (&_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (rygel_playbin_player_player);
		rygel_playbin_player_player = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	_tmp4_ = rygel_playbin_player_player;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}


static gboolean rygel_playbin_player_seek_with_format (RygelPlaybinPlayer* self, GstFormat format, gint64 target) {
	gboolean result = FALSE;
	gboolean seeked = FALSE;
	gdouble speed = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp13_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_new_playback_speed;
	_tmp1_ = rygel_media_player_play_speed_to_double ((RygelMediaPlayer*) self, _tmp0_);
	speed = _tmp1_;
	_tmp2_ = speed;
	if (_tmp2_ > ((gdouble) 0)) {
		GstElement* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
		GstFormat _tmp5_ = 0;
		gint64 _tmp6_ = 0LL;
		gboolean _tmp7_ = FALSE;
		_tmp3_ = self->priv->_playbin;
		_tmp4_ = speed;
		_tmp5_ = format;
		_tmp6_ = target;
		_tmp7_ = gst_element_seek (_tmp3_, _tmp4_, _tmp5_, (GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_SKIP) | GST_SEEK_FLAG_ACCURATE, GST_SEEK_TYPE_SET, _tmp6_, GST_SEEK_TYPE_NONE, (gint64) -1);
		seeked = _tmp7_;
	} else {
		GstElement* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		GstFormat _tmp10_ = 0;
		gint64 _tmp11_ = 0LL;
		gboolean _tmp12_ = FALSE;
		_tmp8_ = self->priv->_playbin;
		_tmp9_ = speed;
		_tmp10_ = format;
		_tmp11_ = target;
		_tmp12_ = gst_element_seek (_tmp8_, _tmp9_, _tmp10_, (GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_SKIP) | GST_SEEK_FLAG_ACCURATE, GST_SEEK_TYPE_SET, (gint64) 0, GST_SEEK_TYPE_SET, _tmp11_);
		seeked = _tmp12_;
	}
	_tmp13_ = seeked;
	if (_tmp13_) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp14_ = self->priv->_new_playback_speed;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (self->priv->_playback_speed);
		self->priv->_playback_speed = _tmp15_;
	}
	result = seeked;
	return result;
}


static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, gint64 time) {
	RygelPlaybinPlayer * self;
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gboolean _tmp6_ = FALSE;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = time;
	_tmp1_ = self->priv->_new_playback_speed;
	g_debug ("rygel-playbin-player.vala:409: Seeking %lld usec, play speed %s", _tmp0_, _tmp1_);
	_tmp2_ = time;
	_tmp3_ = rygel_media_player_get_duration ((RygelMediaPlayer*) self);
	_tmp4_ = _tmp3_;
	if (_tmp2_ > _tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = time;
	_tmp6_ = rygel_playbin_player_seek_with_format (self, GST_FORMAT_TIME, _tmp5_ * GST_USECOND);
	result = _tmp6_;
	return result;
}


static gboolean rygel_playbin_player_real_seek_bytes (RygelMediaPlayer* base, gint64 bytes) {
	RygelPlaybinPlayer * self;
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	gint64 size = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gboolean _tmp4_ = FALSE;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp8_ = 0LL;
	gboolean _tmp9_ = FALSE;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = bytes;
	_tmp1_ = self->priv->_new_playback_speed;
	g_debug ("rygel-playbin-player.vala:421: Seeking %lld bytes, play speed %s", _tmp0_, _tmp1_);
	_tmp2_ = rygel_media_player_get_size ((RygelMediaPlayer*) self);
	_tmp3_ = _tmp2_;
	size = _tmp3_;
	_tmp5_ = size;
	if (_tmp5_ > ((gint64) 0)) {
		gint64 _tmp6_ = 0LL;
		gint64 _tmp7_ = 0LL;
		_tmp6_ = bytes;
		_tmp7_ = size;
		_tmp4_ = _tmp6_ > _tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = bytes;
	_tmp9_ = rygel_playbin_player_seek_with_format (self, GST_FORMAT_BYTES, _tmp8_);
	result = _tmp9_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_protocols != NULL) ? _vala_array_dup1 (RYGEL_PLAYBIN_PLAYER_protocols, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_protocols);
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_mime_types != NULL) ? _vala_array_dup2 (RYGEL_PLAYBIN_PLAYER_mime_types, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_mime_types);
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static inline GstCaps* _dynamic_get_caps0 (GstElement* obj) {
	GstCaps* result;
	g_object_get (obj, "caps", &result, NULL);
	return result;
}


static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self) {
	gboolean result = FALSE;
	GstElement* typefind = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstCaps* caps = NULL;
	GstElement* _tmp2_ = NULL;
	GstCaps* _tmp3_ = NULL;
	GstCaps* _tmp4_ = NULL;
	GstStructure* structure = NULL;
	GstCaps* _tmp5_ = NULL;
	GstStructure* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GstStructure* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_playbin;
	_tmp1_ = gst_bin_get_by_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gst_bin_get_type ()) ? ((GstBin*) _tmp0_) : NULL, "typefind");
	_g_object_unref0 (typefind);
	typefind = _tmp1_;
	_tmp2_ = typefind;
	_tmp3_ = _dynamic_get_caps0 (_tmp2_);
	_tmp4_ = _tmp3_;
	caps = _tmp4_;
	_tmp5_ = caps;
	_tmp6_ = gst_caps_get_structure (_tmp5_, (guint) 0);
	structure = _tmp6_;
	_tmp8_ = structure;
	_tmp9_ = gst_structure_get_name (_tmp8_);
	if (g_strcmp0 (_tmp9_, "image/jpeg") == 0) {
		_tmp7_ = TRUE;
	} else {
		GstStructure* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp10_ = structure;
		_tmp11_ = gst_structure_get_name (_tmp10_);
		_tmp7_ = g_strcmp0 (_tmp11_, "image/png") == 0;
	}
	result = _tmp7_;
	_gst_caps_unref0 (caps);
	_g_object_unref0 (typefind);
	return result;
}


static inline gchar* _dynamic_get_current_uri1 (GstElement* obj) {
	gchar* result;
	g_object_get (obj, "current-uri", &result, NULL);
	return result;
}


static inline gchar* _dynamic_get_uri2 (GstElement* obj) {
	gchar* result;
	g_object_get (obj, "uri", &result, NULL);
	return result;
}


static void rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message) {
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_DURATION_CHANGED:
		{
			GstElement* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			_tmp2_ = self->priv->_playbin;
			_tmp3_ = gst_element_query_duration (_tmp2_, GST_FORMAT_TIME, NULL);
			if (_tmp3_) {
				g_object_notify ((GObject*) self, "duration");
			}
			break;
		}
		case GST_MESSAGE_STATE_CHANGED:
		{
			GstMessage* _tmp4_ = NULL;
			GstObject* _tmp5_ = NULL;
			GstElement* _tmp6_ = NULL;
			_tmp4_ = message;
			_tmp5_ = _tmp4_->src;
			_tmp6_ = self->priv->_playbin;
			if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gst_object_get_type (), GstObject)) {
				GstState old_state = 0;
				GstState new_state = 0;
				GstState pending = 0;
				GstMessage* _tmp7_ = NULL;
				GstState _tmp8_ = 0;
				GstState _tmp9_ = 0;
				GstState _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				GstState _tmp12_ = 0;
				GstState _tmp29_ = 0;
				gboolean _tmp31_ = FALSE;
				GstState _tmp32_ = 0;
				_tmp7_ = message;
				gst_message_parse_state_changed (_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
				old_state = _tmp8_;
				new_state = _tmp9_;
				pending = _tmp10_;
				_tmp12_ = old_state;
				if (_tmp12_ == GST_STATE_READY) {
					GstState _tmp13_ = 0;
					_tmp13_ = new_state;
					_tmp11_ = _tmp13_ == GST_STATE_PAUSED;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					gboolean _tmp14_ = FALSE;
					GstElement* _tmp27_ = NULL;
					gboolean _tmp28_ = FALSE;
					_tmp14_ = self->priv->uri_update_hint;
					if (_tmp14_) {
						gchar* uri = NULL;
						GstElement* _tmp15_ = NULL;
						gchar* _tmp16_ = NULL;
						gchar* _tmp17_ = NULL;
						gboolean _tmp18_ = FALSE;
						const gchar* _tmp19_ = NULL;
						const gchar* _tmp20_ = NULL;
						self->priv->uri_update_hint = FALSE;
						_tmp15_ = self->priv->_playbin;
						_tmp16_ = _dynamic_get_current_uri1 (_tmp15_);
						_tmp17_ = _tmp16_;
						uri = _tmp17_;
						_tmp19_ = self->priv->_uri;
						_tmp20_ = uri;
						if (g_strcmp0 (_tmp19_, _tmp20_) != 0) {
							const gchar* _tmp21_ = NULL;
							_tmp21_ = uri;
							_tmp18_ = g_strcmp0 (_tmp21_, "") != 0;
						} else {
							_tmp18_ = FALSE;
						}
						if (_tmp18_) {
							GstElement* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
							gchar* _tmp24_ = NULL;
							gchar* _tmp25_ = NULL;
							gchar* _tmp26_ = NULL;
							_tmp22_ = self->priv->_playbin;
							_tmp23_ = _dynamic_get_uri2 (_tmp22_);
							_tmp24_ = _tmp23_;
							_g_free0 (self->priv->_uri);
							self->priv->_uri = _tmp24_;
							g_object_notify ((GObject*) self, "uri");
							_tmp25_ = rygel_playbin_player_generate_basic_didl (self);
							_tmp26_ = _tmp25_;
							rygel_media_player_set_metadata ((RygelMediaPlayer*) self, _tmp26_);
							_g_free0 (_tmp26_);
						}
						_g_free0 (uri);
					}
					_tmp27_ = self->priv->_playbin;
					_tmp28_ = gst_element_query_duration (_tmp27_, GST_FORMAT_TIME, NULL);
					if (_tmp28_) {
						g_object_notify ((GObject*) self, "duration");
					}
				}
				_tmp29_ = pending;
				if (_tmp29_ == GST_STATE_VOID_PENDING) {
					GstState _tmp30_ = 0;
					_tmp30_ = new_state;
					switch (_tmp30_) {
						case GST_STATE_PAUSED:
						{
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PAUSED_PLAYBACK");
							break;
						}
						case GST_STATE_NULL:
						{
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
							break;
						}
						case GST_STATE_PLAYING:
						{
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
							break;
						}
						default:
						{
							break;
						}
					}
				}
				_tmp32_ = old_state;
				if (_tmp32_ == GST_STATE_PAUSED) {
					GstState _tmp33_ = 0;
					_tmp33_ = new_state;
					_tmp31_ = _tmp33_ == GST_STATE_PLAYING;
				} else {
					_tmp31_ = FALSE;
				}
				if (_tmp31_) {
					rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
				}
			}
			break;
		}
		case GST_MESSAGE_EOS:
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = rygel_playbin_player_is_rendering_image (self);
			if (!_tmp34_) {
				g_debug ("rygel-playbin-player.vala:567: EOS");
				rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "EOS");
			} else {
				g_debug ("rygel-playbin-player.vala:570: Content is image, ignoring EOS");
			}
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* _error_ = NULL;
			gchar* debug_message = NULL;
			GstMessage* _tmp35_ = NULL;
			GError* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			GstElement* _tmp38_ = NULL;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			GError* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			_tmp35_ = message;
			gst_message_parse_error (_tmp35_, &_tmp36_, &_tmp37_);
			_g_error_free0 (_error_);
			_error_ = _tmp36_;
			_g_free0 (debug_message);
			debug_message = _tmp37_;
			_tmp38_ = self->priv->_playbin;
			g_object_get ((GstObject*) _tmp38_, "name", &_tmp39_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = _tmp40_;
			_tmp42_ = _error_;
			_tmp43_ = _tmp42_->message;
			_tmp44_ = debug_message;
			g_warning ("rygel-playbin-player.vala:580: Error from GStreamer element %s: %s (%s" \
")", _tmp41_, _tmp43_, _tmp44_);
			_g_free0 (_tmp41_);
			g_warning ("rygel-playbin-player.vala:584: Going to STOPPED state");
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
			_g_free0 (debug_message);
			_g_error_free0 (_error_);
			break;
		}
		default:
		break;
	}
}


static inline void _dynamic_set_extra_headers3 (GstElement* obj, GstStructure* value) {
	g_object_set (obj, "extra-headers", value, NULL);
}


static inline void _dynamic_set_user_agent4 (GstElement* obj, gchar* value) {
	g_object_set (obj, "user-agent", value, NULL);
}


static void rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self, GstElement* pipeline, GstElement* source) {
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_ = NULL;
	GType _tmp2_ = 0UL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pipeline != NULL);
	g_return_if_fail (source != NULL);
	_tmp1_ = source;
	_tmp2_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp1_);
	_tmp3_ = g_type_name (_tmp2_);
	if (g_strcmp0 (_tmp3_, "GstSoupHTTPSrc") == 0) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = self->priv->transfer_mode;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp5_ = NULL;
		GstStructure* structure = NULL;
		GstStructure* _tmp6_ = NULL;
		GstStructure* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GValue _tmp9_ = {0};
		GstElement* _tmp10_ = NULL;
		GstStructure* _tmp11_ = NULL;
		GstElement* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp5_ = self->priv->transfer_mode;
		g_debug ("rygel-playbin-player.vala:595: Setting transfer mode to %s", _tmp5_);
		_tmp6_ = gst_structure_new_empty ("HTTPHeaders");
		structure = _tmp6_;
		_tmp7_ = structure;
		_tmp8_ = self->priv->transfer_mode;
		g_value_init (&_tmp9_, G_TYPE_STRING);
		g_value_set_string (&_tmp9_, _tmp8_);
		gst_structure_set_value (_tmp7_, "transferMode.dlna.org", &_tmp9_);
		G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
		_tmp10_ = source;
		_tmp11_ = structure;
		_dynamic_set_extra_headers3 (_tmp10_, _tmp11_);
		_tmp12_ = source;
		_tmp13_ = rygel_media_player_get_user_agent ((RygelMediaPlayer*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_dynamic_set_user_agent4 (_tmp12_, _tmp15_);
		_g_free0 (_tmp15_);
		_gst_structure_free0 (structure);
	}
}


static void rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self, GParamSpec* pspec) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	self->priv->uri_update_hint = TRUE;
}


/**
     * Generate basic DIDLLite information.
     *
     * This is used when the URI gets changed externally. DLNA requires that a
     * minimum DIDLLite is always present if the URI is not empty.
     */
static gchar* rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self) {
	gchar* result = NULL;
	GUPnPDIDLLiteWriter* writer = NULL;
	GUPnPDIDLLiteWriter* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* item = NULL;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	GUPnPDIDLLiteResource* resource = NULL;
	GUPnPDIDLLiteResource* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GFile* file = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gupnp_didl_lite_writer_new (NULL);
	writer = _tmp0_;
	_tmp1_ = gupnp_didl_lite_writer_add_item (writer);
	item = _tmp1_;
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) item, "1");
	gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) item, "-1");
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) item, "object.item");
	_tmp2_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) item);
	resource = _tmp2_;
	_tmp3_ = self->priv->_uri;
	gupnp_didl_lite_resource_set_uri (resource, _tmp3_);
	_tmp4_ = rygel_media_player_get_uri ((RygelMediaPlayer*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_new_for_uri (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	file = _tmp8_;
	_tmp9_ = g_file_get_basename (file);
	_tmp10_ = _tmp9_;
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) item, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = gupnp_didl_lite_writer_get_string (writer);
	result = _tmp11_;
	_g_object_unref0 (file);
	_g_object_unref0 (resource);
	_g_object_unref0 (item);
	_g_object_unref0 (writer);
	return result;
}


static inline void _dynamic_set_auto_flush_bus5 (GstElement* obj, gboolean value) {
	g_object_set (obj, "auto-flush-bus", value, NULL);
}


static void _rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender, GstElement* source, gpointer self) {
	rygel_playbin_player_on_source_setup ((RygelPlaybinPlayer*) self, _sender, source);
}


gulong _dynamic_source_setup1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
	return g_signal_connect_object (obj, signal_name, handler, data, 0);
}


static void _rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_playbin_player_on_uri_notify ((RygelPlaybinPlayer*) self, pspec);
}


static void _rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
	rygel_playbin_player_bus_handler ((RygelPlaybinPlayer*) self, _sender, message);
}


static void rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self) {
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstBus* bus = NULL;
	GstElement* _tmp3_ = NULL;
	GstBus* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_playbin;
	_dynamic_set_auto_flush_bus5 (_tmp0_, FALSE);
	_tmp1_ = self->priv->_playbin;
	_dynamic_source_setup1_connect (_tmp1_, "source_setup", (GCallback) _rygel_playbin_player_on_source_setup_dynamic_source_setup0_, self);
	_tmp2_ = self->priv->_playbin;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::uri", (GCallback) _rygel_playbin_player_on_uri_notify_g_object_notify, self, 0);
	_tmp3_ = self->priv->_playbin;
	_tmp4_ = gst_element_get_bus (_tmp3_);
	bus = _tmp4_;
	gst_bus_add_signal_watch_full (bus, G_PRIORITY_DEFAULT);
	g_signal_connect_object (bus, "message", (GCallback) _rygel_playbin_player_bus_handler_gst_bus_message, self, 0);
	_g_object_unref0 (bus);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void __lambda4_ (RygelPlaybinPlayer* self, GUPnPDIDLLiteObject* object) {
	GList* resources = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	g_return_if_fail (object != NULL);
	_tmp0_ = object;
	_tmp1_ = gupnp_didl_lite_object_get_resources (_tmp0_);
	resources = _tmp1_;
	_tmp2_ = resources;
	{
		GList* resource_collection = NULL;
		GList* resource_it = NULL;
		resource_collection = _tmp2_;
		for (resource_it = resource_collection; resource_it != NULL; resource_it = resource_it->next) {
			GUPnPDIDLLiteResource* _tmp3_ = NULL;
			GUPnPDIDLLiteResource* resource = NULL;
			_tmp3_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) resource_it->data);
			resource = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				const gchar* _tmp5_ = NULL;
				GUPnPDIDLLiteResource* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				_tmp5_ = self->priv->_uri;
				_tmp6_ = resource;
				_tmp7_ = gupnp_didl_lite_resource_get_uri (_tmp6_);
				_tmp8_ = _tmp7_;
				if (g_strcmp0 (_tmp5_, _tmp8_) == 0) {
					GUPnPDIDLLiteResource* _tmp9_ = NULL;
					glong _tmp10_ = 0L;
					glong _tmp11_ = 0L;
					_tmp9_ = resource;
					_tmp10_ = gupnp_didl_lite_resource_get_duration (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp4_ = _tmp11_ > ((glong) 0);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GUPnPDIDLLiteResource* _tmp12_ = NULL;
					glong _tmp13_ = 0L;
					glong _tmp14_ = 0L;
					_tmp12_ = resource;
					_tmp13_ = gupnp_didl_lite_resource_get_duration (_tmp12_);
					_tmp14_ = _tmp13_;
					self->priv->_parsed_duration = (gint64) (_tmp14_ * G_TIME_SPAN_SECOND);
					g_object_notify ((GObject*) self, "duration");
				}
				_g_object_unref0 (resource);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (resources);
}


static void ___lambda4__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self) {
	__lambda4_ ((RygelPlaybinPlayer*) self, object);
}


static void rygel_playbin_player_guess_duration (RygelPlaybinPlayer* self) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	GUPnPDIDLLiteParser* reader = NULL;
	GUPnPDIDLLiteParser* _tmp3_ = NULL;
	GUPnPDIDLLiteParser* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_metadata;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = self->priv->_metadata;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = gupnp_didl_lite_parser_new ();
	reader = _tmp3_;
	_tmp4_ = reader;
	g_signal_connect_object (_tmp4_, "object-available", (GCallback) ___lambda4__gupnp_didl_lite_parser_object_available, self, 0);
	{
		GUPnPDIDLLiteParser* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = reader;
		_tmp6_ = self->priv->_metadata;
		gupnp_didl_lite_parser_parse_didl (_tmp5_, _tmp6_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_debug ("rygel-playbin-player.vala:664: Failed to parse meta-data: %s", _tmp8_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (reader);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (reader);
}


GstElement* rygel_playbin_player_get_playbin (RygelPlaybinPlayer* self) {
	GstElement* result;
	GstElement* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_playbin;
	result = _tmp0_;
	return result;
}


static void rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self, GstElement* value) {
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_playbin);
	self->priv->_playbin = _tmp1_;
	g_object_notify ((GObject *) self, "playbin");
}


static gchar* rygel_playbin_player_real_get_playback_state (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playback_state;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_playback_state (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	GstState state = 0;
	GstState pending = 0;
	GstElement* _tmp0_ = NULL;
	GstState _tmp1_ = 0;
	GstState _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	gst_element_get_state (_tmp0_, &_tmp1_, &_tmp2_, (GstClockTime) GST_MSECOND);
	state = _tmp1_;
	pending = _tmp2_;
	_tmp3_ = value;
	g_debug ("rygel-playbin-player.vala:112: Changing playback state to %s.", _tmp3_);
	_tmp4_ = value;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("STOPPED")))) {
		switch (0) {
			default:
			{
				gboolean _tmp8_ = FALSE;
				GstState _tmp9_ = 0;
				_tmp9_ = state;
				if (_tmp9_ != GST_STATE_NULL) {
					_tmp8_ = TRUE;
				} else {
					GstState _tmp10_ = 0;
					_tmp10_ = pending;
					_tmp8_ = _tmp10_ != GST_STATE_VOID_PENDING;
				}
				if (_tmp8_) {
					GstElement* _tmp11_ = NULL;
					_tmp11_ = self->priv->_playbin;
					gst_element_set_state (_tmp11_, GST_STATE_NULL);
				} else {
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					_tmp12_ = value;
					_tmp13_ = g_strdup (_tmp12_);
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp13_;
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
		switch (0) {
			default:
			{
				gboolean _tmp14_ = FALSE;
				GstState _tmp15_ = 0;
				_tmp15_ = state;
				if (_tmp15_ != GST_STATE_PAUSED) {
					_tmp14_ = TRUE;
				} else {
					GstState _tmp16_ = 0;
					_tmp16_ = pending;
					_tmp14_ = _tmp16_ != GST_STATE_VOID_PENDING;
				}
				if (_tmp14_) {
					GstElement* _tmp17_ = NULL;
					_tmp17_ = self->priv->_playbin;
					gst_element_set_state (_tmp17_, GST_STATE_PAUSED);
				} else {
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp18_ = value;
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp19_;
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("PLAYING")))) {
		switch (0) {
			default:
			{
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				_tmp22_ = self->priv->_new_playback_speed;
				_tmp23_ = self->priv->_playback_speed;
				if (g_strcmp0 (_tmp22_, _tmp23_) != 0) {
					gboolean _tmp24_ = FALSE;
					GstState _tmp25_ = 0;
					_tmp25_ = state;
					if (_tmp25_ == GST_STATE_PLAYING) {
						_tmp24_ = TRUE;
					} else {
						GstState _tmp26_ = 0;
						_tmp26_ = state;
						_tmp24_ = _tmp26_ == GST_STATE_PAUSED;
					}
					_tmp21_ = _tmp24_;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					GstState _tmp27_ = 0;
					_tmp27_ = pending;
					_tmp20_ = _tmp27_ == GST_STATE_VOID_PENDING;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					gchar* _tmp28_ = NULL;
					gint64 _tmp29_ = 0LL;
					gint64 _tmp30_ = 0LL;
					_tmp28_ = g_strdup ("TRANSITIONING");
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp28_;
					_tmp29_ = rygel_media_player_get_position ((RygelMediaPlayer*) self);
					_tmp30_ = _tmp29_;
					rygel_media_player_seek ((RygelMediaPlayer*) self, _tmp30_);
				} else {
					gboolean _tmp31_ = FALSE;
					GstState _tmp32_ = 0;
					_tmp32_ = state;
					if (_tmp32_ != GST_STATE_PLAYING) {
						_tmp31_ = TRUE;
					} else {
						GstState _tmp33_ = 0;
						_tmp33_ = pending;
						_tmp31_ = _tmp33_ != GST_STATE_VOID_PENDING;
					}
					if (_tmp31_) {
						gchar* _tmp34_ = NULL;
						GstElement* _tmp35_ = NULL;
						_tmp34_ = g_strdup ("TRANSITIONING");
						_g_free0 (self->priv->_playback_state);
						self->priv->_playback_state = _tmp34_;
						_tmp35_ = self->priv->_playbin;
						gst_element_set_state (_tmp35_, GST_STATE_PLAYING);
					} else {
						const gchar* _tmp36_ = NULL;
						gchar* _tmp37_ = NULL;
						_tmp36_ = value;
						_tmp37_ = g_strdup (_tmp36_);
						_g_free0 (self->priv->_playback_state);
						self->priv->_playback_state = _tmp37_;
					}
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("EOS")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				_tmp38_ = value;
				_tmp39_ = g_strdup (_tmp38_);
				_g_free0 (self->priv->_playback_state);
				self->priv->_playback_state = _tmp39_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	g_object_notify ((GObject *) self, "playback-state");
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_playbin_player_real_get_allowed_playback_speeds (RygelMediaPlayer* base, int* result_length1) {
	gchar** result;
	RygelPlaybinPlayer* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_allowed_playback_speeds;
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static gchar* rygel_playbin_player_real_get_playback_speed (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playback_speed;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_playback_speed (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_new_playback_speed);
	self->priv->_new_playback_speed = _tmp1_;
	g_object_notify ((GObject *) self, "playback-speed");
}


static gchar* rygel_playbin_player_real_get_uri (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static inline void _dynamic_set_uri6 (GstElement* obj, gchar* value) {
	g_object_set (obj, "uri", value, NULL);
}


static inline void _dynamic_set_uri7 (GstElement* obj, const gchar* value) {
	g_object_set (obj, "uri", value, NULL);
}


static void rygel_playbin_player_real_set_uri (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp22_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	_tmp2_ = self->priv->_playbin;
	gst_element_set_state (_tmp2_, GST_STATE_READY);
	_tmp4_ = rygel_playbin_player_has_dlna_src;
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = value;
		_tmp6_ = g_str_has_prefix (_tmp5_, "http");
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GstElement* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		g_debug ("rygel-playbin-player.vala:199: Trying to use DLNA src element");
		_tmp7_ = self->priv->_playbin;
		_tmp8_ = value;
		_tmp9_ = g_strconcat ("dlna+", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_dynamic_set_uri6 (_tmp7_, _tmp10_);
		_g_free0 (_tmp10_);
	} else {
		GstElement* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = self->priv->_playbin;
		_tmp12_ = value;
		_dynamic_set_uri7 (_tmp11_, _tmp12_);
	}
	_tmp13_ = value;
	if (g_strcmp0 (_tmp13_, "") != 0) {
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GQuark _tmp17_ = 0U;
		static GQuark _tmp16_label0 = 0;
		static GQuark _tmp16_label1 = 0;
		static GQuark _tmp16_label2 = 0;
		static GQuark _tmp16_label3 = 0;
		static GQuark _tmp16_label4 = 0;
		rygel_playbin_player_guess_duration (self);
		_tmp14_ = self->priv->_playback_state;
		_tmp15_ = _tmp14_;
		_tmp17_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
		if (_tmp17_ == ((0 != _tmp16_label0) ? _tmp16_label0 : (_tmp16_label0 = g_quark_from_static_string ("NO_MEDIA_PRESENT")))) {
			switch (0) {
				default:
				{
					gchar* _tmp18_ = NULL;
					_tmp18_ = g_strdup ("STOPPED");
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp18_;
					g_object_notify ((GObject*) self, "playback-state");
					break;
				}
			}
		} else if (_tmp17_ == ((0 != _tmp16_label1) ? _tmp16_label1 : (_tmp16_label1 = g_quark_from_static_string ("STOPPED")))) {
			switch (0) {
				default:
				{
					break;
				}
			}
		} else if (_tmp17_ == ((0 != _tmp16_label2) ? _tmp16_label2 : (_tmp16_label2 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
			switch (0) {
				default:
				{
					GstElement* _tmp19_ = NULL;
					_tmp19_ = self->priv->_playbin;
					gst_element_set_state (_tmp19_, GST_STATE_PAUSED);
					break;
				}
			}
		} else if ((_tmp17_ == ((0 != _tmp16_label3) ? _tmp16_label3 : (_tmp16_label3 = g_quark_from_static_string ("EOS")))) || (_tmp17_ == ((0 != _tmp16_label4) ? _tmp16_label4 : (_tmp16_label4 = g_quark_from_static_string ("PLAYING"))))) {
			switch (0) {
				default:
				{
					GstElement* _tmp20_ = NULL;
					_tmp20_ = self->priv->_playbin;
					gst_element_set_state (_tmp20_, GST_STATE_PLAYING);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
	} else {
		gchar* _tmp21_ = NULL;
		_tmp21_ = g_strdup ("NO_MEDIA_PRESENT");
		_g_free0 (self->priv->_playback_state);
		self->priv->_playback_state = _tmp21_;
		g_object_notify ((GObject*) self, "playback-state");
	}
	_tmp22_ = value;
	g_debug ("rygel-playbin-player.vala:228: URI set to %s.", _tmp22_);
	g_object_notify ((GObject *) self, "uri");
}


static gchar* rygel_playbin_player_real_get_mime_type (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_mime_type;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_mime_type (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp1_;
	g_object_notify ((GObject *) self, "mime-type");
}


static gchar* rygel_playbin_player_real_get_metadata (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_metadata;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_metadata (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	self->priv->_parsed_duration = (gint64) 0;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_metadata);
	self->priv->_metadata = _tmp1_;
	g_object_notify ((GObject *) self, "metadata");
}


static gboolean rygel_playbin_player_real_get_can_seek (RygelMediaPlayer* base) {
	gboolean result;
	RygelPlaybinPlayer* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp1_ = self->priv->transfer_mode;
	if (g_strcmp0 (_tmp1_, RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE) != 0) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp2_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = g_str_has_prefix (_tmp4_, "image/");
		_tmp0_ = !_tmp5_;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean rygel_playbin_player_real_get_can_seek_bytes (RygelMediaPlayer* base) {
	gboolean result;
	RygelPlaybinPlayer* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp1_ = self->priv->transfer_mode;
	if (g_strcmp0 (_tmp1_, RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE) != 0) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp2_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = g_str_has_prefix (_tmp4_, "image/");
		_tmp0_ = !_tmp5_;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gchar* rygel_playbin_player_real_get_user_agent (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_user_agent;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_user_agent (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_user_agent);
	self->priv->_user_agent = _tmp1_;
	g_object_notify ((GObject *) self, "user-agent");
}


static gchar* rygel_playbin_player_real_get_content_features (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_content_features;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_content_features (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	gchar* pi_string = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = value;
	_tmp4_ = g_strdup_printf (RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE, _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	pi_string = _tmp5_;
	{
		GUPnPProtocolInfo* _tmp6_ = NULL;
		GUPnPProtocolInfo* _tmp7_ = NULL;
		GUPnPProtocolInfo* _tmp8_ = NULL;
		GUPnPDLNAFlags flags = 0;
		GUPnPProtocolInfo* _tmp9_ = NULL;
		GUPnPDLNAFlags _tmp10_ = 0;
		GUPnPDLNAFlags _tmp11_ = 0;
		GUPnPDLNAFlags _tmp12_ = 0;
		_tmp7_ = gupnp_protocol_info_new_from_string (pi_string, &_inner_error_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (self->priv->protocol_info);
		self->priv->protocol_info = _tmp8_;
		_tmp9_ = self->priv->protocol_info;
		_tmp10_ = gupnp_protocol_info_get_dlna_flags (_tmp9_);
		_tmp11_ = _tmp10_;
		flags = _tmp11_;
		_tmp12_ = flags;
		if ((_tmp12_ & GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) {
			gchar* _tmp13_ = NULL;
			_tmp13_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE);
			_g_free0 (self->priv->transfer_mode);
			self->priv->transfer_mode = _tmp13_;
		} else {
			GUPnPDLNAFlags _tmp14_ = 0;
			_tmp14_ = flags;
			if ((_tmp14_ & GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) {
				gchar* _tmp15_ = NULL;
				_tmp15_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING);
				_g_free0 (self->priv->transfer_mode);
				self->priv->transfer_mode = _tmp15_;
			} else {
				_g_free0 (self->priv->transfer_mode);
				self->priv->transfer_mode = NULL;
			}
		}
		_g_object_unref0 (_tmp6_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_object_unref0 (self->priv->protocol_info);
		self->priv->protocol_info = NULL;
		_g_free0 (self->priv->transfer_mode);
		self->priv->transfer_mode = NULL;
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (pi_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = value;
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (self->priv->_content_features);
	self->priv->_content_features = _tmp17_;
	_g_free0 (pi_string);
	g_object_notify ((GObject *) self, "content-features");
}


static gdouble rygel_playbin_player_real_get_volume (RygelMediaPlayer* base) {
	gdouble result;
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	_tmp1_ = gst_stream_volume_get_volume (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gst_stream_volume_get_type ()) ? ((GstStreamVolume*) _tmp0_) : NULL, GST_STREAM_VOLUME_FORMAT_CUBIC);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_volume (RygelMediaPlayer* base, gdouble value) {
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	_tmp1_ = value;
	gst_stream_volume_set_volume (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gst_stream_volume_get_type ()) ? ((GstStreamVolume*) _tmp0_) : NULL, GST_STREAM_VOLUME_FORMAT_CUBIC, _tmp1_);
	_tmp2_ = value;
	g_debug ("rygel-playbin-player.vala:308: volume set to %f.", _tmp2_);
	g_object_notify ((GObject *) self, "volume");
}


static gint64 rygel_playbin_player_real_get_duration (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 dur = 0LL;
	GstElement* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	self = (RygelPlaybinPlayer*) base;
	dur = (gint64) 0;
	_tmp0_ = self->priv->_playbin;
	_tmp2_ = gst_element_query_duration (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	dur = _tmp1_;
	if (_tmp2_) {
		gint64 _tmp3_ = 0LL;
		_tmp3_ = dur;
		result = _tmp3_ / GST_USECOND;
		return result;
	} else {
		gint64 _tmp4_ = 0LL;
		_tmp4_ = self->priv->_parsed_duration;
		result = _tmp4_;
		return result;
	}
}


static inline GstElement* _dynamic_get_source8 (GstElement* obj) {
	GstElement* result;
	g_object_get (obj, "source", &result, NULL);
	return result;
}


static inline GstElement* _dynamic_get_source9 (GstElement* obj) {
	GstElement* result;
	g_object_get (obj, "source", &result, NULL);
	return result;
}


static gint64 rygel_playbin_player_real_get_size (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 dur = 0LL;
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	dur = (gint64) 0;
	_tmp1_ = self->priv->_playbin;
	_tmp2_ = _dynamic_get_source8 (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GstElement* _tmp4_ = NULL;
		GstElement* _tmp5_ = NULL;
		GstElement* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gboolean _tmp8_ = FALSE;
		_tmp4_ = self->priv->_playbin;
		_tmp5_ = _dynamic_get_source9 (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp8_ = gst_element_query_duration (_tmp6_, GST_FORMAT_BYTES, &_tmp7_);
		dur = _tmp7_;
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint64 _tmp9_ = 0LL;
		_tmp9_ = dur;
		result = _tmp9_;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}


static gint64 rygel_playbin_player_real_get_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 pos = 0LL;
	GstElement* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	_tmp2_ = gst_element_query_position (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	pos = _tmp1_;
	if (_tmp2_) {
		gint64 _tmp3_ = 0LL;
		_tmp3_ = pos;
		result = _tmp3_ / GST_USECOND;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}


static inline GstElement* _dynamic_get_source10 (GstElement* obj) {
	GstElement* result;
	g_object_get (obj, "source", &result, NULL);
	return result;
}


static inline GstElement* _dynamic_get_source11 (GstElement* obj) {
	GstElement* result;
	g_object_get (obj, "source", &result, NULL);
	return result;
}


static gint64 rygel_playbin_player_real_get_byte_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 pos = 0LL;
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	pos = (gint64) 0;
	_tmp1_ = self->priv->_playbin;
	_tmp2_ = _dynamic_get_source10 (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GstElement* _tmp4_ = NULL;
		GstElement* _tmp5_ = NULL;
		GstElement* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gboolean _tmp8_ = FALSE;
		_tmp4_ = self->priv->_playbin;
		_tmp5_ = _dynamic_get_source11 (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp8_ = gst_element_query_position (_tmp6_, GST_FORMAT_BYTES, &_tmp7_);
		pos = _tmp7_;
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint64 _tmp9_ = 0LL;
		_tmp9_ = pos;
		result = _tmp9_;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}


GList* rygel_playbin_player_get_supported_profiles (RygelPlaybinPlayer* self) {
	GList* result;
	GList* _tmp0_ = NULL;
	GList* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_supported_profiles;
	if (_tmp0_ == NULL) {
		RygelDLNAProfile* _tmp1_ = NULL;
		RygelDLNAProfile* _tmp2_ = NULL;
		RygelDLNAProfile* _tmp3_ = NULL;
		RygelDLNAProfile* _tmp4_ = NULL;
		RygelDLNAProfile* _tmp5_ = NULL;
		RygelDLNAProfile* _tmp6_ = NULL;
		RygelDLNAProfile* _tmp7_ = NULL;
		RygelDLNAProfile* _tmp8_ = NULL;
		RygelDLNAProfile* _tmp9_ = NULL;
		RygelDLNAProfile* _tmp10_ = NULL;
		RygelDLNAProfile* _tmp11_ = NULL;
		RygelDLNAProfile* _tmp12_ = NULL;
		RygelDLNAProfile* _tmp13_ = NULL;
		RygelDLNAProfile* _tmp14_ = NULL;
		RygelDLNAProfile* _tmp15_ = NULL;
		RygelDLNAProfile* _tmp16_ = NULL;
		RygelDLNAProfile* _tmp17_ = NULL;
		RygelDLNAProfile* _tmp18_ = NULL;
		__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
		self->priv->_supported_profiles = NULL;
		_tmp1_ = rygel_dlna_profile_new ("JPEG_SM", "image/jpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp1_);
		_tmp2_ = rygel_dlna_profile_new ("JPEG_MED", "image/jpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp2_);
		_tmp3_ = rygel_dlna_profile_new ("JPEG_LRG", "image/jpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp3_);
		_tmp4_ = rygel_dlna_profile_new ("PNG_LRG", "image/png");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp4_);
		_tmp5_ = rygel_dlna_profile_new ("MP3", "audio/mpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp5_);
		_tmp6_ = rygel_dlna_profile_new ("MP3X", "audio/mpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp6_);
		_tmp7_ = rygel_dlna_profile_new ("AAC_ADTS_320", "audio/vnd.dlna.adts");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp7_);
		_tmp8_ = rygel_dlna_profile_new ("AAC_ISO_320", "audio/mp4");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp8_);
		_tmp9_ = rygel_dlna_profile_new ("AAC_ISO_320", "audio/3gpp");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp9_);
		_tmp10_ = rygel_dlna_profile_new ("LPCM", "audio/l16;rate=44100;channels=2");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp10_);
		_tmp11_ = rygel_dlna_profile_new ("LPCM", "audio/l16;rate=44100;channels=1");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp11_);
		_tmp12_ = rygel_dlna_profile_new ("WMABASE", "audio/x-ms-wma");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp12_);
		_tmp13_ = rygel_dlna_profile_new ("WMAFULL", "audio/x-ms-wma");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp13_);
		_tmp14_ = rygel_dlna_profile_new ("WMAPRO", "audio/x-ms-wma");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp14_);
		_tmp15_ = rygel_dlna_profile_new ("MPEG_TS_SD_EU_ISO", "video/mpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp15_);
		_tmp16_ = rygel_dlna_profile_new ("MPEG_TS_SD_NA_ISO", "video/mpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp16_);
		_tmp17_ = rygel_dlna_profile_new ("MPEG_TS_HD_NA_ISO", "video/mpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp17_);
		_tmp18_ = rygel_dlna_profile_new ("AVC_MP4_BL_CIF15_AAC_520", "video/mp4");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp18_);
	}
	_tmp19_ = self->priv->_supported_profiles;
	result = _tmp19_;
	return result;
}


static void rygel_playbin_player_class_init (RygelPlaybinPlayerClass * klass) {
	gboolean _tmp0_ = FALSE;
	rygel_playbin_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPlaybinPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_playbin_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_playbin_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_playbin_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBIN, g_param_spec_object ("playbin", "playbin", "playbin", gst_element_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS, g_param_spec_boxed ("allowed-playback-speeds", "allowed-playback-speeds", "allowed-playback-speeds", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED, g_param_spec_string ("playback-speed", "playback-speed", "playback-speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CAN_SEEK, g_param_spec_boolean ("can-seek", "can-seek", "can-seek", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CAN_SEEK_BYTES, g_param_spec_boolean ("can-seek-bytes", "can-seek-bytes", "can-seek-bytes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_USER_AGENT, g_param_spec_string ("user-agent", "user-agent", "user-agent", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES, g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_VOLUME, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_DURATION, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_POSITION, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_BYTE_POSITION, g_param_spec_int64 ("byte-position", "byte-position", "byte-position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES, g_param_spec_pointer ("supported-profiles", "supported-profiles", "supported-profiles", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = gst_uri_protocol_is_supported (GST_URI_SRC, "dlna+http");
	rygel_playbin_player_has_dlna_src = _tmp0_;
}


static void rygel_playbin_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
	rygel_playbin_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->seek = (gboolean (*)(RygelMediaPlayer*, gint64)) rygel_playbin_player_real_seek;
	iface->seek_bytes = (gboolean (*)(RygelMediaPlayer*, gint64)) rygel_playbin_player_real_seek_bytes;
	iface->get_protocols = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_protocols;
	iface->get_mime_types = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_mime_types;
	iface->get_playback_state = rygel_playbin_player_real_get_playback_state;
	iface->set_playback_state = rygel_playbin_player_real_set_playback_state;
	iface->get_allowed_playback_speeds = rygel_playbin_player_real_get_allowed_playback_speeds;
	iface->get_playback_speed = rygel_playbin_player_real_get_playback_speed;
	iface->set_playback_speed = rygel_playbin_player_real_set_playback_speed;
	iface->get_uri = rygel_playbin_player_real_get_uri;
	iface->set_uri = rygel_playbin_player_real_set_uri;
	iface->get_mime_type = rygel_playbin_player_real_get_mime_type;
	iface->set_mime_type = rygel_playbin_player_real_set_mime_type;
	iface->get_metadata = rygel_playbin_player_real_get_metadata;
	iface->set_metadata = rygel_playbin_player_real_set_metadata;
	iface->get_can_seek = rygel_playbin_player_real_get_can_seek;
	iface->get_can_seek_bytes = rygel_playbin_player_real_get_can_seek_bytes;
	iface->get_user_agent = rygel_playbin_player_real_get_user_agent;
	iface->set_user_agent = rygel_playbin_player_real_set_user_agent;
	iface->get_content_features = rygel_playbin_player_real_get_content_features;
	iface->set_content_features = rygel_playbin_player_real_set_content_features;
	iface->get_volume = rygel_playbin_player_real_get_volume;
	iface->set_volume = rygel_playbin_player_real_set_volume;
	iface->get_duration = rygel_playbin_player_real_get_duration;
	iface->get_size = rygel_playbin_player_real_get_size;
	iface->get_position = rygel_playbin_player_real_get_position;
	iface->get_byte_position = rygel_playbin_player_real_get_byte_position;
}


static void rygel_playbin_player_instance_init (RygelPlaybinPlayer * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	self->priv = RYGEL_PLAYBIN_PLAYER_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("NO_MEDIA_PRESENT");
	self->priv->_playback_state = _tmp0_;
	_tmp1_ = g_strdup ("1/16");
	_tmp2_ = g_strdup ("1/8");
	_tmp3_ = g_strdup ("1/4");
	_tmp4_ = g_strdup ("1/2");
	_tmp5_ = g_strdup ("1");
	_tmp6_ = g_strdup ("2");
	_tmp7_ = g_strdup ("4");
	_tmp8_ = g_strdup ("8");
	_tmp9_ = g_strdup ("16");
	_tmp10_ = g_strdup ("32");
	_tmp11_ = g_strdup ("64");
	_tmp12_ = g_new0 (gchar*, 11 + 1);
	_tmp12_[0] = _tmp1_;
	_tmp12_[1] = _tmp2_;
	_tmp12_[2] = _tmp3_;
	_tmp12_[3] = _tmp4_;
	_tmp12_[4] = _tmp5_;
	_tmp12_[5] = _tmp6_;
	_tmp12_[6] = _tmp7_;
	_tmp12_[7] = _tmp8_;
	_tmp12_[8] = _tmp9_;
	_tmp12_[9] = _tmp10_;
	_tmp12_[10] = _tmp11_;
	self->priv->_allowed_playback_speeds = _tmp12_;
	self->priv->_allowed_playback_speeds_length1 = 11;
	self->priv->__allowed_playback_speeds_size_ = self->priv->_allowed_playback_speeds_length1;
	_tmp13_ = g_strdup ("1");
	self->priv->_new_playback_speed = _tmp13_;
	_tmp14_ = g_strdup ("1");
	self->priv->_playback_speed = _tmp14_;
	self->priv->transfer_mode = NULL;
	self->priv->uri_update_hint = FALSE;
	self->priv->_uri = NULL;
	_tmp15_ = g_strdup ("");
	self->priv->_mime_type = _tmp15_;
	_tmp16_ = g_strdup ("");
	self->priv->_metadata = _tmp16_;
	_tmp17_ = g_strdup ("");
	self->priv->_content_features = _tmp17_;
}


static void rygel_playbin_player_finalize (GObject* obj) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
	_g_object_unref0 (self->priv->_playbin);
	_g_free0 (self->priv->_playback_state);
	self->priv->_allowed_playback_speeds = (_vala_array_free (self->priv->_allowed_playback_speeds, self->priv->_allowed_playback_speeds_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_new_playback_speed);
	_g_free0 (self->priv->_playback_speed);
	_g_free0 (self->priv->transfer_mode);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_user_agent);
	_g_free0 (self->priv->_content_features);
	_g_object_unref0 (self->priv->protocol_info);
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
	G_OBJECT_CLASS (rygel_playbin_player_parent_class)->finalize (obj);
}


/**
 * Implementation of RygelMediaPlayer for GStreamer.
 *
 * This class is useful only when implementing Rygel plugins.
 */
GType rygel_playbin_player_get_type (void) {
	static volatile gsize rygel_playbin_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playbin_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinPlayer), 0, (GInstanceInitFunc) rygel_playbin_player_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_playbin_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playbin_player_type_id;
		rygel_playbin_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaybinPlayer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playbin_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_playbin_player_type_id__volatile, rygel_playbin_player_type_id);
	}
	return rygel_playbin_player_type_id__volatile;
}


static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN:
		g_value_set_object (value, rygel_playbin_player_get_playbin (self));
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS:
		{
			int length;
			g_value_take_boxed (value, rygel_media_player_get_allowed_playback_speeds ((RygelMediaPlayer*) self, &length));
		}
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED:
		g_value_take_string (value, rygel_media_player_get_playback_speed ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI:
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE:
		g_value_take_string (value, rygel_media_player_get_mime_type ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_METADATA:
		g_value_take_string (value, rygel_media_player_get_metadata ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_CAN_SEEK:
		g_value_set_boolean (value, rygel_media_player_get_can_seek ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_CAN_SEEK_BYTES:
		g_value_set_boolean (value, rygel_media_player_get_can_seek_bytes ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_USER_AGENT:
		g_value_take_string (value, rygel_media_player_get_user_agent ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES:
		g_value_take_string (value, rygel_media_player_get_content_features ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_DURATION:
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_SIZE:
		g_value_set_int64 (value, rygel_media_player_get_size ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_POSITION:
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_BYTE_POSITION:
		g_value_set_int64 (value, rygel_media_player_get_byte_position ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES:
		g_value_set_pointer (value, rygel_playbin_player_get_supported_profiles (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN:
		rygel_playbin_player_set_playbin (self, g_value_get_object (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED:
		rygel_media_player_set_playback_speed ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI:
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE:
		rygel_media_player_set_mime_type ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_METADATA:
		rygel_media_player_set_metadata ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_USER_AGENT:
		rygel_media_player_set_user_agent ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES:
		rygel_media_player_set_content_features ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



