#!/usr/bin/python
# -*-coding: UTF-8 -*-
# bbou@ac-toulouse.fr
# GPL License
# 2005-08-21 09:57:26 
# ipcalc.py

import string

#######################################################################

def int2Ip(a):
	b4=(a) & 0xFF
	b3=(a >> 8)  & 0xFF
	b2=(a >> 16)  & 0xFF
	b1=(a >> 24)  & 0xFF
	return str(b1)+'.'+str(b2)+'.'+str(b3)+'.'+str(b4)
    
def ip2Int(s):
	bs=s.split('.')
	b4=int(bs[0]) << 24
	b3=int(bs[1]) << 16
	b2=int(bs[2]) << 8
	b1=int(bs[3])
	return b1 | b2 | b3 | b4
    
def toMask(s):
	sm=s.split('/')[1]
	nm=int(sm)
	return 0xFFFFFFFF<<(32-nm)

def toBase(s):
	s=s.split('/')[0]
	return ip2Int(s)

def toNet(a,m):
	return int2Ip(a & m)+'/'+int2Ip(m)
