function main() {
    startApplication("sasview");
    activateItem(waitForObjectItem(":MainWindow.menubar_QMenuBar", "Tool"));
    activateItem(waitForObjectItem(":MainWindow.menuTool_QMenu", "Generic Scattering Calculator"));
    setWindowState(waitForObject(":MainWindow_MainSasViewWindow"), WindowState.Minimize);
    test.compare(waitForObjectExists(":GenericScatteringCalculator_GenericScatteringCalculator").windowTitle, "Generic SAS Calculator");
    test.compare(waitForObjectExists(":GenericScatteringCalculator_GenericScatteringCalculator").visible, true);
    test.compare(waitForObjectExists(":GenericScatteringCalculator_GenericScatteringCalculator").modal, false);
    test.compare(waitForObjectExists(":groupBox_Datafile.txtData_QLineEdit").toolTip, "Display name of loaded datafile.");
    test.compare(waitForObjectExists(":groupBox_Datafile.txtData_QLineEdit").text, "Default SLD Profile");
    test.compare(waitForObjectExists(":groupBox_Datafile.cmdLoad_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":groupBox_Datafile.cmdDraw_QPushButton").enabled, false);
    test.compare(waitForObjectExists(":groupBox_Datafile.cbShape_QComboBox").currentText, "Rectangular");
    test.compare(waitForObjectExists(":groupBox_Datafile.cbShape_QComboBox").enabled, true);
    test.compare(waitForObjectExists(":groupBox_Datafile.cbShape_QComboBox").count, 2);
    test.compare(waitForObjectExists(":groupBox_Datafile.cbShape_QComboBox").currentIndex, 0);
    test.compare(waitForObjectExists(":groupBox_SLDPixelInfo.txtNoPixels_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_SLDPixelInfo.txtNoPixels_QLineEdit").text, "1000");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracIn_QLineEdit").text, "1.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracIn_QLineEdit").toolTip, "<html><head/><body><p>Ratio of spin up/(spin up + spin down) neutrons after the analyzer.</p><p>It must be between 0 and 1.</p><p>It is equal to 0.5 for unpolarized neutrons.</p></body></html>");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracOut_QLineEdit").text, "1.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracOut_QLineEdit").toolTip, "<html><head/><body><p>Ratio of spin up/(spin up + spin down) neutrons before the sample.</p><p>It must be between 0 and 1.</p><p>It is equal to 0.5 for unpolarized neutrons.</p></body></html>");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracOut_QLineEdit").readOnly, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpTheta_QLineEdit").readOnly, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpTheta_QLineEdit").text, "0.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpTheta_QLineEdit").toolTip, "<html><head/><body><p>Polarization angle.</p></body></html>");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtBackground_QLineEdit").text, "0.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtBackground_QLineEdit").readOnly, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtSolventSLD_QLineEdit").text, "0.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtSolventSLD_QLineEdit").readOnly, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtTotalVolume_QLineEdit").toolTip, "<html><head/><body><p>Default total volume calculated from the pizel information (or natural density for pdb file)</p></body></html>");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtTotalVolume_QLineEdit").readOnly, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtTotalVolume_QLineEdit").text, "216000.0");
    test.compare(waitForObjectExists(":GenericScatteringCalculator.cmdCompute_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":GenericScatteringCalculator.cmdReset_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":GenericScatteringCalculator.cmdClose_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":GenericScatteringCalculator.cmdHelp_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":groupBox_SLDPixelInfo.cmdDrawpoints_QPushButton").enabled, false);
    test.compare(waitForObjectExists(":groupBox_SLDPixelInfo.cmdSave_QPushButton").enabled, false);
    clickButton(waitForObject(":GenericScatteringCalculator.cmdCompute_QPushButton"));
    
    sendEvent("QMoveEvent", waitForObject(":_Plotter2D"), 1165, 717, 1309, 731);
    sendEvent("QMoveEvent", waitForObject(":_Plotter2D"), 1178, 699, 1322, 713);
    sendEvent("QMoveEvent", waitForObject(":_Plotter2D"), 1026, 396, 1170, 410);
    sendEvent("QCloseEvent", waitForObject(":_Plotter2D"));
    mouseClick(waitForObject(":groupBox_Datafile.cbShape_QComboBox"), 122, 9, 0, Qt.LeftButton);
    mouseClick(waitForObjectItem(":groupBox_Datafile.cbShape_QComboBox", "Ellipsoid"), 108, 9, 0, Qt.LeftButton);
    mouseClick(waitForObject(":groupBox_Qrange.txtNoQBins_QLineEdit"), 31, 15, 0, Qt.LeftButton);
    
    mouseClick(waitForObject(":groupBox_Datafile.cbShape_QComboBox"), 137, 8, 0, Qt.LeftButton);
    mouseClick(waitForObjectItem(":groupBox_Datafile.cbShape_QComboBox", "Ellipsoid"), 125, 2, 0, Qt.LeftButton);
    clickButton(waitForObject(":GenericScatteringCalculator.cmdCompute_QPushButton"));
    sendEvent("QCloseEvent", waitForObject(":_Plotter2D"));
    mouseClick(waitForObject(":groupBox_InputParam.txtUpFracIn_QLineEdit"), 33, 10, 0, Qt.LeftButton);
    type(waitForObject(":groupBox_InputParam.txtUpFracIn_QLineEdit"), "<Left>");
    type(waitForObject(":groupBox_InputParam.txtUpFracIn_QLineEdit"), "<Left>");
    type(waitForObject(":groupBox_InputParam.txtUpFracIn_QLineEdit"), "<Backspace>");
    type(waitForObject(":groupBox_InputParam.txtUpFracIn_QLineEdit"), "2");
    type(waitForObject(":groupBox_InputParam.txtUpFracIn_QLineEdit"), "<Backspace>");
    type(waitForObject(":groupBox_InputParam.txtUpFracIn_QLineEdit"), "2");
    mouseDrag(waitForObject(":groupBox_InputParam.txtUpTheta_QLineEdit"), 24, 11, -26, 11, 1, Qt.LeftButton);
    type(waitForObject(":groupBox_InputParam.txtUpTheta_QLineEdit"), "ee");
    type(waitForObject(":groupBox_InputParam.txtUpTheta_QLineEdit"), "<Backspace>");
    type(waitForObject(":groupBox_InputParam.txtUpTheta_QLineEdit"), "<Backspace>");
    type(waitForObject(":groupBox_InputParam.txtUpTheta_QLineEdit"), "2.0");
    type(waitForObject(":groupBox_InputParam.txtUpTheta_QLineEdit"), "<Tab>");
    type(waitForObject(":groupBox_InputParam.txtBackground_QLineEdit"), "1.0");
    type(waitForObject(":groupBox_InputParam.txtBackground_QLineEdit"), "<Tab>");
    type(waitForObject(":groupBox_InputParam.txtScale_QLineEdit"), "2.0");
    type(waitForObject(":groupBox_InputParam.txtScale_QLineEdit"), "<Tab>");
    type(waitForObject(":groupBox_InputParam.txtSolventSLD_QLineEdit"), "10.0");
    type(waitForObject(":groupBox_InputParam.txtSolventSLD_QLineEdit"), "<Tab>");
    clickButton(waitForObject(":GenericScatteringCalculator.cmdCompute_QPushButton"));

    clickButton(waitForObject(":GenericScatteringCalculator.cmdReset_QPushButton"));
 
    test.compare(waitForObjectExists(":groupBox_Datafile.txtData_QLineEdit").toolTip, "Display name of loaded datafile.");
    test.compare(waitForObjectExists(":groupBox_Datafile.txtData_QLineEdit").text, "Default SLD Profile");
    test.compare(waitForObjectExists(":groupBox_Datafile.cmdLoad_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":groupBox_Datafile.cmdDraw_QPushButton").enabled, false);
    test.compare(waitForObjectExists(":groupBox_Datafile.cbShape_QComboBox").currentText, "Rectangular");
    test.compare(waitForObjectExists(":groupBox_Datafile.cbShape_QComboBox").enabled, true);
    test.compare(waitForObjectExists(":groupBox_Datafile.cbShape_QComboBox").count, 2);
    test.compare(waitForObjectExists(":groupBox_Datafile.cbShape_QComboBox").currentIndex, 0);
    test.compare(waitForObjectExists(":groupBox_SLDPixelInfo.txtNoPixels_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_SLDPixelInfo.txtNoPixels_QLineEdit").text, "1000");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracIn_QLineEdit").text, "1.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracIn_QLineEdit").toolTip, "<html><head/><body><p>Ratio of spin up/(spin up + spin down) neutrons after the analyzer.</p><p>It must be between 0 and 1.</p><p>It is equal to 0.5 for unpolarized neutrons.</p></body></html>");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracOut_QLineEdit").text, "1.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracOut_QLineEdit").toolTip, "<html><head/><body><p>Ratio of spin up/(spin up + spin down) neutrons before the sample.</p><p>It must be between 0 and 1.</p><p>It is equal to 0.5 for unpolarized neutrons.</p></body></html>");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracOut_QLineEdit").readOnly, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpTheta_QLineEdit").readOnly, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpTheta_QLineEdit").text, "0.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpTheta_QLineEdit").toolTip, "<html><head/><body><p>Polarization angle.</p></body></html>");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtBackground_QLineEdit").text, "0.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtBackground_QLineEdit").readOnly, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtSolventSLD_QLineEdit").text, "0.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtSolventSLD_QLineEdit").readOnly, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtTotalVolume_QLineEdit").toolTip, "<html><head/><body><p>Default total volume calculated from the pizel information (or natural density for pdb file)</p></body></html>");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtTotalVolume_QLineEdit").readOnly, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtTotalVolume_QLineEdit").text, "216000.0");
    test.compare(waitForObjectExists(":GenericScatteringCalculator.cmdCompute_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":GenericScatteringCalculator.cmdReset_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":GenericScatteringCalculator.cmdClose_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":GenericScatteringCalculator.cmdHelp_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":groupBox_SLDPixelInfo.cmdDrawpoints_QPushButton").enabled, false);
    snooze(2)

    clickButton(waitForObject(":groupBox_Datafile.cmdLoad_QPushButton"));
    waitForObjectItem(":stackedWidget.listView_QListView", "test");
    doubleClickItem(":stackedWidget.listView_QListView", "test", 43, 15, 0, Qt.LeftButton);
    waitForObjectItem(":stackedWidget.listView_QListView", "coordinate\\_data");
    doubleClickItem(":stackedWidget.listView_QListView", "coordinate\\_data", 42, 7, 0, Qt.LeftButton);
    waitForObjectItem(":stackedWidget.listView_QListView", "A\\_Raw\\_Example-1\\.omf");
    doubleClickItem(":stackedWidget.listView_QListView", "A\\_Raw\\_Example-1\\.omf", 36, 10, 0, Qt.LeftButton);
    snooze(2)
    test.compare(waitForObjectExists(":groupBox_Datafile.txtData_QLineEdit").text, "A_Raw_Example-1.omf");
    test.compare(waitForObjectExists(":groupBox_Datafile.cbShape_QComboBox").enabled, false);
    test.compare(waitForObjectExists(":groupBox_Datafile.cmdDraw_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracIn_QLineEdit").text, "1.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracIn_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracOut_QLineEdit").text, "1.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpFracOut_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpTheta_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtUpTheta_QLineEdit").text, "0.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtBackground_QLineEdit").enabled, true);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtBackground_QLineEdit").text, "0.01");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtScale_QLineEdit").text, "1.02");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtScale_QLineEdit").enabled, true);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtSolventSLD_QLineEdit").enabled, true);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtSolventSLD_QLineEdit").text, "0.0");
    test.compare(waitForObjectExists(":groupBox_InputParam.txtTotalVolume_QLineEdit").enabled, true);
    test.compare(waitForObjectExists(":groupBox_InputParam.txtTotalVolume_QLineEdit").text, "128000000.0");
    test.compare(waitForObjectExists(":groupBox_SLDPixelInfo.txtNoPixels_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_SLDPixelInfo.txtNoPixels_QLineEdit").text, "16000");
    test.compare(waitForObjectExists(":groupBox_5.txtMx_QLineEdit").text, "7.855e-09");
    test.compare(waitForObjectExists(":groupBox_5.txtMx_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_5.txtMy_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_5.txtMy_QLineEdit").text, "4.5169e-08");
    test.compare(waitForObjectExists(":groupBox_5.txtMz_QLineEdit").text, "9.9511e-10");
    test.compare(waitForObjectExists(":groupBox_5.txtMz_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_5.txtNucl_QLineEdit").text, "0");
    test.compare(waitForObjectExists(":groupBox_5.txtNucl_QLineEdit").enabled, true);
    test.compare(waitForObjectExists(":groupBox_6.txtXnodes_QLineEdit").text, "40");
    test.compare(waitForObjectExists(":groupBox_6.txtXnodes_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_6.txtYnodes_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_6.txtYnodes_QLineEdit").text, "40");
    test.compare(waitForObjectExists(":groupBox_6.txtZnodes_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_6.txtZnodes_QLineEdit").text, "10");
    test.compare(waitForObjectExists(":groupBox_Stepsize.txtXstepsize_QLineEdit").text, "20");
    test.compare(waitForObjectExists(":groupBox_Stepsize.txtXstepsize_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_Stepsize.txtYstepsize_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_Stepsize.txtYstepsize_QLineEdit").text, "20");
    test.compare(waitForObjectExists(":groupBox_Stepsize.txtZstepsize_QLineEdit").enabled, false);
    test.compare(waitForObjectExists(":groupBox_Stepsize.txtZstepsize_QLineEdit").text, "20");
    test.compare(waitForObjectExists(":groupBox_SLDPixelInfo.cmdDrawpoints_QPushButton").enabled, true);
    test.compare(waitForObjectExists(":groupBox_SLDPixelInfo.cmdSave_QPushButton").enabled, true);
    sendEvent("QMouseEvent", waitForObject(":groupBox_SLDPixelInfo.cmdSave_QPushButton"), QEvent.MouseButtonPress, 44, 5, Qt.LeftButton, 1, 0);
    sendEvent("QMouseEvent", waitForObject(":groupBox_SLDPixelInfo.cmdSave_QPushButton"), QEvent.MouseButtonRelease, 44, 5, Qt.LeftButton, 0, 0);
    test.compare(waitForObjectExists(":QFileDialog_QFileDialog").windowTitle, "Save As");
    test.compare(waitForObjectExists(":QFileDialog_QFileDialog").modal, true);
    test.compare(waitForObjectExists(":fileNameEdit_QLineEdit").text, "sld_file");
    test.compare(waitForObjectExists(":QFileDialog.fileTypeCombo_QComboBox").count, 1);
    test.compare(waitForObjectExists(":QFileDialog.fileTypeCombo_QComboBox").currentText, "SLD file (*.sld)");
    test.compare(waitForObjectExists(":QFileDialog.fileTypeCombo_QComboBox").currentIndex, 0);
    sendEvent("QMouseEvent", waitForObject(":QFileDialog.Cancel_QPushButton"), QEvent.MouseButtonPress, 36, 12, Qt.LeftButton, 1, 0);
    sendEvent("QMouseEvent", waitForObject(":QFileDialog.Cancel_QPushButton"), QEvent.MouseButtonRelease, 36, 12, Qt.LeftButton, 0, 0);
    clickButton(waitForObject(":groupBox_SLDPixelInfo.cmdDrawpoints_QPushButton"));
    
}
