# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/rexml.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: rexml testing of xml

=end
module SiSU_Rexml
  # load XML file for REXML parsing
  begin
    require 'rexml/document' if FileTest.directory?("#{Config::CONFIG['rubylibdir']}/rexml") #Config::CONFIG['sitedir']
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).error('rexml/document NOT FOUND (LoadError)')
  end
  require_relative 'param'                              # param.rb
    include SiSU_Param
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  include SiSU_Viz
  class Rexml
    begin
      require 'rexml/document' if FileTest.directory?("#{Config::CONFIG['rubylibdir']}/rexml") #Config::CONFIG['sitedir']
    rescue LoadError
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).error('rexml/document NOT FOUND (LoadError)')
    end
    def initialize(md,fno)
      @md,@fno=md,fno
      @env=SiSU_Env::InfoEnv.new(@md.fns)
      @prog=SiSU_Env::InfoProgram.new #(md.fns) #if md
      if File.file?(@fno)
        @fnap=@fno #index.xml causes problems with index.html in server config
      end
      @e_head='/document/head'
      @e_title='/document/head/title'
      @e_object='/document/body/object'
      @e_ocn='/document/body/object/ocn'
      @e_text='/document/body/object/text'
      @e_endnote='/document/body/object/endnote'
    end
    def xml
      begin
        if FileTest.file?(@fnap)
          if @prog.rexml !=false \
          and FileTest.directory?('/usr/lib/ruby/1.8/rexml/') #note values can be other than true
            xmlfile=IO.readlines(@fnap,'').join
            begin
              @xmldoc=REXML::Document.new xmlfile
              SiSU_Screen::Ansi.new(@md.opt.act[:color_state][:set],'invert','REXML',"XML document #{@fnap} loaded").colorize unless @md.opt.act[:quiet][:set]==:on
              if (@opt.act[:verbose][:set]==:on \
              || @opt.act[:verbose_plus][:set]==:on)
                @xmldoc.elements.each(@e_head) do |e|
                  SiSU_Screen::Ansi.new(@md.opt.act[:color_state][:set],'brown',e).colorize unless @md.opt.act[:quiet][:set]==:on
                end
              end
            rescue REXML::ParseException
              puts 'broken XML'
            end
          end
        else
          SiSU_Screen::Ansi.new(@md.opt.act[:color_state][:set],'fuchsia',"File Not Found #{xmlfile}",'requested XML processing skipped').colorize unless @md.opt.act[:quiet][:set]==:on
          exit
        end
      rescue
        SiSU_Errors::Rescued.new($!,$@,@md.opt.cmd,@md.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
  end
end
__END__
 misc
e.each do |element|
  element.each do |child|
    if child.is_a?(REXML::Text)
      puts "Text: #{child.to_s.inspect}"
    else
      puts "SubElement: #{child.name}"
    end
  end
end
