-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Crypto                                                              --
--                                                                           --
-- Description                                                               --
--                                                                           --
-- This package supplies some basic type declarations that are common        --
-- to all packages rooted here.                                              --
--                                                                           --
-- Language                                                                  --
--   Specification : SPARK                                                   --
--   Private Part  : N/A                                                     --
--   Body          : N/A                                                     --
--                                                                           --
-- Runtime Requirements and Dependencies                                     --
--   None                                                                    --
--                                                                           --
-- Verification                                                              --
--   N/A                                                                     --
--                                                                           --
-- Exceptions                                                                --
--   None                                                                    --
-------------------------------------------------------------------------------

with SPARK;
with SPARK.Unsigned;
--# inherit SPARK,
--#         SPARK.Unsigned;
package SPARK.Crypto
is
   subtype I3   is Natural range 0 .. 2;
   subtype I4   is Natural range 0 .. 3;
   subtype I6   is Natural range 0 .. 5;
   subtype I7   is Natural range 0 .. 6;
   subtype I8   is Natural range 0 .. 7;
   subtype I9   is Natural range 0 .. 8;
   subtype I16  is Natural range 0 .. 15;
   subtype I64  is Natural range 0 .. 63;
   subtype I128 is Natural range 0 .. 127;

   type Byte_Seq is array (Natural range <>) of Unsigned.Byte;
   for Byte_Seq'Alignment use 8;

   subtype Byte_Seq_4   is Byte_Seq (I4);
   subtype Byte_Seq_8   is Byte_Seq (I8);
   subtype Byte_Seq_16  is Byte_Seq (I16);
   subtype Byte_Seq_64  is Byte_Seq (I64);
   subtype Byte_Seq_128 is Byte_Seq (I128);

   -- 2**N bytes is 2**(N-3) 64-bit words
   subtype Word_Count_T is Natural range 0 .. ((Natural'Last + 1) / 8 - 1);
   subtype Positive_Word_Count_T is Natural range 1 .. Word_Count_T'Last;

   type U64_Seq is array (Word_Count_T range <>) of Unsigned.U64;
   for U64_Seq'Alignment use 8;

   subtype U64_Seq_3  is U64_Seq (I3);
   subtype U64_Seq_4  is U64_Seq (I4);
   subtype U64_Seq_8  is U64_Seq (I8);
   subtype U64_Seq_9  is U64_Seq (I9);
   subtype U64_Seq_16 is U64_Seq (I16);

end SPARK.Crypto;
