-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Ada.Streams.Stream_IO;

package Utility is
   subtype String_1_Index is Positive range 1 .. 1;
   subtype String_1 is String (String_1_Index);

   subtype String_3_Index is Positive range 1 .. 3;
   subtype String_3 is String (String_3_Index);

   --  Subprograms Format_Int, Get_File_Size and Put_Message_With_Duration
   --  were previously in Safe_IO.

   -- returns Item as a String of just the right given Width
   function Format_Int (Item  : in Integer;
                        Width : in Integer) return String;

   --  Read and return size of File, using Ada.Streams.Stream_IO
   --  On a 32-bit machine that allows files >2GB, I doubt this will
   --  work, but if anyone has a 2GB VCG file, then that's their
   --  problem!
   function Get_File_Size (File : in String) return Ada.Streams.Stream_IO.Count;

   procedure Put_Message_With_Duration (Message : in String;
                                        D       : in Duration);

   --  Print Str to Standard_Output if CMD.Verbose is True
   procedure Debug (Str : in String);

   --  True iff File is >= 5 chars and ends in ".vcg" (case insensitive)
   function Is_A_VCG_File (File : in String) return Boolean;

   --  True iff File is >= 5 chars and ends in ".dpc" (case insensitive)
   function Is_A_DPC_File (File : in String) return Boolean;

end Utility;
