/*
 * ====================================================================
 * Copyright (c) 2000-2003 CollabNet.  All rights reserved.
 *
 * This file is licensed as  described in the file COPYING.CollabNet,
 * which you should  have received as part of this distribution.  The
 * terms are also available at
 * http://subversion.tigris.org/license-1.html. If  newer versions of
 * this license are posted there, you may use a newer version instead,
 * at your option.
 * ====================================================================
 */
/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_VERSION_H
#define _SC_VERSION_H

/* Symbols that define the version number.
 * TODO: Modify before each snapshot, milestone or release.
 */

/* Version numbers: <major>.<minor>.<patch> */

/** Major version number.
 *
 */
#define SUBCOMMANDER_VER_MAJOR      2

/** Minor version number.
 *
 * Modify when new functionality is added or new interfaces are
 * defined.
 */
#define SUBCOMMANDER_VER_MINOR      0

/** Patch number.
 *
 * Modify for every released patch.
 */
#define SUBCOMMANDER_VER_PATCH      0



/** Revision number: The working copy revision we build from.
 *
 * This constant is used to generate the build number part of the
 * Windows file version. Its value remains 0 in the repository.
 *
 * This will be automatically generated from the ouptput of
 * 'svnversion .' reduced to a single number.
 */
#define SUBCOMMANDER_VER_REVISION    0


/** Revision tag number: The working copy revision we build from.
 *
 * This tag will be generated from the output of 'svnversion .'. It
 * remains 'r0' in the repository.
 */

#define SUBCOMMANDER_VER_REVISION_TAG  "r0"


/** Special Version description: a string, describing a special build.
 *
 * This tag will be generated. It remains 'dev build' in the
 * repository.
 */

#define SUBCOMMANDER_SPECIALBUILD
#define SUBCOMMANDER_SPECIALBUILD_DESCRIPTION "dev build"


/** Build Date: a string of the build date.
 *
 * This tag will be generated. It remains 'now' in the repository.
 */

#define SUBCOMMANDER_DATE    "now"


/** Build Type: a string of the build type: debug or release. */

#if _DEBUG
#  define SUBCOMMANDER_BUILD  "debug"
#else
#  define SUBCOMMANDER_BUILD  "release"
#endif


/* Version strings composed from the above definitions. */

#define STRINGIFY(n)  STRINGIFY2(n)
#define STRINGIFY2(n) #n

/** Version number */
#define SUBCOMMANDER_VER_NUM       STRINGIFY(SUBCOMMANDER_VER_MAJOR) \
                               "." STRINGIFY(SUBCOMMANDER_VER_MINOR) \
                               "." STRINGIFY(SUBCOMMANDER_VER_PATCH)

/** Complete version string */
#define SUBCOMMANDER_VERSION       SUBCOMMANDER_VER_NUM \
                              " (" SUBCOMMANDER_VER_REVISION_TAG \
                              ", " SUBCOMMANDER_BUILD \
                              ")"

#endif // _SC_VERSION_H
