
%exception {
   try {
      $action
   }

   // all out_of_range subclasses 
   catch (std::out_of_range &e) {
      PyErr_SetString(PyExc_IndexError, const_cast<char*>(e.what()));
      return NULL;
   }

   // all logic_error subclasses
   catch (std::logic_error &e) {
      PyErr_SetString(PyExc_StandardError, const_cast<char*>(e.what()));
      return NULL;
   }
   // all runtime_error subclasses
   catch (std::runtime_error &e) {
      PyErr_SetString(PyExc_RuntimeError, const_cast<char*>(e.what()));
      return NULL;
   }
   // all the rest
   catch (std::exception &e) {
      PyErr_SetString(PyExc_Exception, const_cast<char*>(e.what()));
      return NULL;
   }
}

