C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE EVADIM
C                       *****************
C
C     ---------------------------------------------------------
     *(NDIM,NPOINS,NELEMS,NFBIDA,NELESS,NELEUS,NELEPR,NELERC,NELERA,
     * NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL,
     * NBRESS,NBRAYS,NBRAIS,NBPRIO,
     * NBMOBS,
     * NDIELE,NDMATS,NDMASS,NBFACE,NCOEMA,NBPHYS,NPPEL,NPOUE,
     * NBICOR,NBCOPR,
     * NBFFLU,NBFECH,NBFRAI,
     * NPOINR,NELRAY,NNSRAY,NNFRAY,NNERAY,
     * NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE)
C     ---------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C              EVALUATION DES DIMENSIONS DES TABLEAUX NECESSAIRES      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !  NPOINS   !  E ! R  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   !  E ! R  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NELESS   !  E ! R  ! NOMBRE D'ELTS DU MAILLAGE SURF SOLIDE        !
C !  NELEUS   !  E ! R  ! NBRE D'ELTS DU MAILLAGE SURF SOLIDE AVEC FLUX!
C !  NELEPR   !  E ! R  ! NBRE D'ELTS DU MAIL VOL SOLIDE PERIODIQUE    !
C !  NELERA   !  E ! R  ! NBRE D'ELTS DU MAIL SURF SOLIDE AVEC RAYT    !
C !  NBCOUS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NBFLUS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DE TYPE FLUX!
C !  NBDIRS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DIRICHLET   !
C !  NBECHS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL COEF ECH    !
C !  NBFLVS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC FLUX VOLUMIQUE !
C !  NBRESS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL RESI CONTACT!
C !  NBRAYS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC RAYONNEMENT    !
C !  NBRAIS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC RAYONNEMENT INF!
C !  NBFRAI   !  E ! R  ! NOMBRE DE FACES SOLIDES AVEC RAYONNEMENT INF !
C !  NBPRIO   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES PERIODIQUES         !
C !  NDIELE   !  E ! R  ! DIMENSION DES ELTS DU PB (2 OU 3)            !
C !  NDMATS   !  E ! R  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NDMASS   !  E ! R  ! NOMBRE DE NOEUDS DES ELTS SURF SOLIDES       !
C !  NBFACE   !  E ! R  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NCOEMA   !  E ! R  ! NOMBRE DE COEF EXTRA DIAG DES MATRICES ELEM  !
C !  NBPHYS   !  E ! R  ! NOMBRE DE VARIABLES PHYSIQUES SUR LE SOLIDE  !
C !  NBICOR   !  E ! R  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !  NBCOPR   !  E ! R  ! NBRE DE CORRESPONDANTS POUR LES NOEUDS PERIOD!
C !  NBMOBS   !  E ! R  ! NBRE DE NOEUDS EN MOUVEMENT                  !
C !  NPOINR   !  E ! R  ! NOMBRE DE NOEUDS DU MAILLAGE RAYONNEMENT     !
C !  NELRAY   !  E ! R  ! NOMBRE D'ELEMENTS DU MAILLAGE RAYONNEMENT    !
C !  A        ! TR ! A  ! TABLEAU DE TRAVAIL REEL                      !
C !  ILONRA   !  E ! D  ! DIMENSION DE A                               !
C !  IA       ! TE ! A  ! TABLEAUX DE TRAVAIL ENTIER                   !
C !  ILONIA   !  E ! D  ! DIMENSION DE IA                              !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C ! /OPTCT/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :  
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "xrefer.h"
#include "optct.h"
#include "mobil.h"
#include "fichct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "divct.h"
#include "syrth.h"
#include "syrthu.h"
C
C**********************************************************************
C
      INTEGER NDX
      PARAMETER (NDX=10)
C
C.. Variables externes
      INTEGER NDIM,NDIELE
      INTEGER NPOINS,NELEMS,NELEPR,NELESS,NELEUS,NELERC,NELERA
      INTEGER NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL
      INTEGER NBRESS,NBRAYS,NBRAIS
      INTEGER NBPRIO,NPPEL,NPOUE
      INTEGER NDMATS,NDMASS,NCOEMA,NBPHYS,NBICOR,NBCOPR,NBMOBS
      INTEGER NBFACE,NBFFLU,NBFECH,NBFRAI
      INTEGER NPOINR,NELRAY,NNSRAY,NNFRAY,NNERAY
      INTEGER NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE
C
C
C.. Variables internes
      INTEGER I,LE,MM(15),ITYP
      INTEGER NRAJOU,NC
      LOGICAL ERR
C
      INTEGER NFBIDA
C**********************************************************************
C
C     0- CAS OU LE COUPLAGE N'EST PAS ACTIVE : METTRE TOUTES LES
C        DIMENSION A 0
C     ==========================================================
C
      IF (NCTHFS.EQ.0) THEN
C
         NDIELE = 1
         NDMATS = 1
         NDMASS = 1
         NCOEMA = 1
         NPOINS = 1
         NELEMS = 1
         NELESS = 1
C
        RETURN
C
      ENDIF
C
C
C     1- INITIALISATIONS
C     ==================
C
C     1.1 Nombre de faces par elements
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      IF (NCTHFS.EQ.2) THEN
        NBFACE = 1
      ELSE
        IF (NDIM.EQ.2) THEN
          NBFACE = 3
        ELSE
          NBFACE = 4
        ENDIF
      ENDIF
C
C     1.2- Dimension des elements (ie: triangles ou tetraedres)
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      IF (NCTHFS.EQ.2 .OR. NDIM .EQ. 2) THEN
         NDIELE = 2
      ELSE
         NDIELE = 3
      ENDIF
C
C
C     1.2 Suite de calcul en maillage mobile
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
       IF (LSUISO .AND. (LSDEPL.OR.LSROTA) .AND. TYPEF.NE.'SYR') THEN
         WRITE(NFECRA,1200)
         STOP
       ENDIF
C
C     2- INITIALISATION DES SIGNIFICATIONS DES REFERENCES
C     ===================================================
C
C
      CALL LECREF
C
      IF (LRAY) CALL LECRER
C
C     5- MAILLAGE ELEMENTS FINIS DU SOLIDE
C     ====================================
C
C     5.1- LECTURE DU MAILLAGE DU SOLIDE
C     ----------------------------------
C
C     Si le maillage element fini a ete genere par SIMAIL
      IF (TYPEF .EQ. 'SIM') THEN
         ITYP=1
      ELSEIF (TYPEF .EQ. 'IDE') THEN
         ITYP=2
      ELSEIF (TYPEF .EQ. 'SYR')THEN
         ITYP=3
      ELSEIF (TYPEF .EQ. 'MED')THEN
         ITYP=4
      ELSE
         WRITE(NFECRA,5100)
         STOP
      ENDIF
      CALL LMAILS(ITYP,LCFACE,
     *            NDIM,NDIELE,NPOINS,
     *            NELEMS,NELESS,NELEUS,NELEPR,NELERC,NELERA,
     *            NBFACE,NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,
     *            NBRESS,NBRAYS,NBRAIS,NBPRIO,NBMOBS,NRAJOU,
     *            NBFFLU,NBFECH,NBFRAI,NFBIDA)
C
C     5.2 Solides en deplacement 
C     --------------------------
C     conservation du nombre initial de noeuds et d'elements
      NBNMA1 = NPOINS
      NBEMA1 = NELEMS
C
C
C     5.3- VERIFICATIONS POUR LE MODELE COQUE
C     ========================================
C     Toute la coque doit etre couplee
C
      IF (NCTHFS.EQ.2) THEN
        ERR = .FALSE.
        IF (NELESS.NE.NELEMS) THEN
          WRITE (NFECRA,5010) NELEMS,NELESS
          ERR = .TRUE.
        ENDIF
        IF (NBCOUS.NE.NPOINS) THEN
          WRITE (NFECRA,5020) NPOINS,NBCOUS
          ERR = .TRUE.
        ENDIF
        IF (ERR) STOP
      ENDIF
C
C
C
C     6- RAYONNEMENT
C     ==============
C
C     6.1 Pre-lecture du maillage pour le rayonnement
C     -----------------------------------------------
      IF (LRAY) THEN
C
         IF (TYPRA .EQ. 'SIM') THEN
            ITYP=1
         ELSEIF (TYPRA .EQ. 'IDE') THEN
            ITYP=2
         ELSEIF (TYPRA .EQ. 'SYR')THEN
            ITYP=3
#ifdef MED
         ELSEIF (TYPRA .EQ. 'MED')THEN
            ITYP=4
#endif
         ELSE
            WRITE(NFECRA,5100)
            STOP
         ENDIF

         CALL LMAILR(ITYP,
     *               NDIM,NPOINR,NELRAY,
     *               NNSRAY,NNFRAY,NNERAY,
     *               NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE)
C
      ENDIF
C
C
C
C     7- VARIABLES FIGEES
C     ===================
C
C     7.1- Cas des modeles coque et general
C     -------------------------------------
      IF (NCTHFS .EQ. 2) THEN
         NDMATS = 6
         NDMASS = 6
         NCOEMA = 9
      ELSEIF (NDIM .EQ. 2) THEN
         NDMATS = 6
         NDMASS = 3
         NCOEMA = 9
      ELSE
         NDMATS = 10
         NDMASS = 6
         NCOEMA = 25
      ENDIF
      IF ( (NBCOUS
     *   .EQ.0) .AND. .NOT. LSYRTH ) 
     *   NCOEMA = NCOEMA/2
C
C     7.2- Nombre de variables physiques
C     ----------------------------------
      IF (NCTHFS.EQ.2) THEN
         NBPHYS = 6
      ELSE
        IF (ISOTRO.EQ.1) THEN
         NBPHYS = 3
        ELSEIF (ISOTRO.EQ.2) THEN
          IF (NDIM.EQ.2) THEN
            NBPHYS = 4
          ELSE
            NBPHYS = 5
          ENDIF
        ELSE
          IF (NDIM.EQ.2) THEN
            NBPHYS = 5
          ELSE
            NBPHYS = 8
          ENDIF
        ENDIF
      ENDIF
C
      IF (NDPROP.EQ.3) THEN
        NPPEL = NDMATS
        NPOUE = NELEMS
      ELSEIF (NDPROP.EQ.2) THEN
        NPPEL = 1
        NPOUE = NELEMS
      ELSE
        NPPEL = 1
        NPOUE = NPOINS
      ENDIF 
C
C     7.3- Flux volumiques
C     --------------------
      IF (NDFLUV.EQ.3) THEN
        NPFEL = NDMATS
      ELSE
        NPFEL = 1
      ENDIF 
C
C     7.3- Maillages coincidents - Nbre d'info pour les correspondants
C     ----------------------------------------------------------------
C
      IF (LCOIN) THEN
        NBICOR = 1
      ELSE
        NBICOR = 2
      ENDIF
C
C     7.4- Periodicite : nombre de correspondants
C     -------------------------------------------
C 
      IF (NBDIPR.LE.1) THEN
        NBCOPR = 1
      ELSEIF (NBDIPR.EQ.2) THEN
        NBCOPR = 3
      ELSE
        NBCOPR = 7
      ENDIF
C  
C     7.5- Modele coque
C     -----------------
      IF (NCTHFS.EQ.2) THEN
        NELEUS = 0
        NELERC = 0
        NELESS = 0
      ENDIF
C
C     7.6- Solides mobiles
C     --------------------
      NBRMOB = 0
C
      IF ((LSTOKC .OR. LECCOR) .AND. (LSDEPL .OR. LSROTA)) THEN
        WRITE(NFECRA,7600)
        LSTOKC = .FALSE.
        LECCOR = .FALSE.
      ENDIF
C
C
C     8- ARRET UTILISATEUR
C     ====================
      LSTOPS = .FALSE.
C
C     9- IMPRESSIONS
C     ==============
C
      IF (NBLBLA.GT.0) THEN
       IF (NCTHFS.EQ.3) THEN        
        IF (.NOT.LCFACE) THEN
         WRITE(NFECRA,8000) NPOINS,NELEMS,NELEUS,
     &                      NELESS,NBCOUS,NBFLUS-NRAJOU,NBDIRS,NBECHS
         WRITE(NFECRA,8010) NELERC,NBRESS,NELEPR,NBPRIO,
     &                      NELERA,NBRAYS,NBRAIS,NBMOBS
         IF (NDFLUV.EQ.1) THEN
           WRITE(NFECRA,8011) NBFLVS
         ELSE
           WRITE(NFECRA,8012) NBFLVS
         ENDIF
         IF (LRAY) 
     &   WRITE(NFECRA,8015) NPOINR,NELRAY,
     &                      NFCSRA,NFCFRA,NFTIRA,NFFIRA,NFPERA,NFMST,
     &                      NNSRAY,NNFRAY,NNERAY
        ELSE
         WRITE(NFECRA,8020) NPOINS,NELEMS,NELEUS,
     &                      NELESS,NBCOUS,NBFFLU,NBDIRS,NBFECH
         WRITE(NFECRA,8030) NELERC,NBRESS,NELEPR,NBPRIO,
     &                      NELERA,NBRAYS,NBFRAI,NBMOBS
         IF (NDFLUV.EQ.1) THEN
           WRITE(NFECRA,8011) NBFLVS
         ELSE
           WRITE(NFECRA,8012) NBFLVS
         ENDIF
         IF (LRAY) 
     &   WRITE(NFECRA,8015) NPOINR,NELRAY,
     &                      NFCSRA,NFCFRA,NFTIRA,NFFIRA,NFPERA,NFMST,
     &                      NNSRAY,NNFRAY
        ENDIF
       ELSE      
        IF (.NOT.LCFACE) THEN
         WRITE(NFECRA,8000) NPOINS,NELEMS,NELEMS,
     &                      NELEMS,NBCOUS,NBFLUS,NBDIRS,NBECHS
         WRITE(NFECRA,8010) NELERC,NBRESS,NELEPR,NBPRIO,
     &                      NELERA,NBRAYS,NBRAIS,NBMOBS
        ELSE
         WRITE(NFECRA,8020) NPOINS,NELEMS,NELEMS,
     &                      NELEMS,NBCOUS,NBFFLU,NBDIRS,NBFECH
         WRITE(NFECRA,8030) NELERC,NBRESS,NELEPR,NBPRIO,
     &                      NELERA,NBRAYS,NBFRAI,NBMOBS
        ENDIF
        IF (NDFLUV.EQ.1) THEN
           WRITE(NFECRA,8011) NBFLVS
        ELSE
           WRITE(NFECRA,8012) NBFLVS
        ENDIF
       ENDIF
C
      ENDIF
C
C     10- STOP EN CAS D'ERREUR
C     ========================
C     
      ERR=.FALSE.
C     10.1- Resistances de contact ne sont pas autorisees en coque
C     ------------------------------------------------------------
C
      IF (NCTHFS.EQ.2 .AND. (NELERC.NE.0 .OR. NBRESS.NE.0)) THEN
        WRITE(NFECRA,9100)
        ERR=.TRUE.
      ENDIF
C
      IF (LRAY.AND.NELERA.EQ.0) THEN
        WRITE(NFECRA,9200)
        ERR=.TRUE.
      ENDIF
C
      IF (ERR) STOP
C
C--------
C FORMATS
C--------
 1200 FORMAT(/,' %% ERREUR EVADIM : EN MAILLAGE MOBILE, LES SUITES DE ',
     &       'CALCUL NE PEUVENT ETRE REALISEES',/,
     &       '                    QU''A PARTIR DU FICHIER GEOMETRIQUE',
     &       ' ISSU DU PRECEDENT CALCUL ',/,
     &       '                    (format SYRTHES) LES COORDONNEES DES',
     &       ' NOEUDS AYANT ETE MODIFIEES')
 1000 FORMAT(A80)
 1100 FORMAT(2A16)
 1105 FORMAT(36I2)
 1330 FORMAT(/,' *** EVADIM : NOMBRE DE POINTS DE BORD FLUIDES: ',I6)
 1410 FORMAT(12I6)
 5100 FORMAT(/,'  %% ERREUR EVADIM : TYPE DE MAILLAGE ELEMENTS',
     &         ' FINIS INCONNU')
 5010 FORMAT(/,'%% ERREUR EVADIM : ERREUR DE MAILLAGE',/,
     &       20X,'En modele coque, toute la coque doit etre couplee ',
     &           'au fluide',/,
     &       20X,'Ici, la coque comporte ',I9,' elements',/,
     &       20X,'Il y en a ',I9,' de declares couples')
 5020 FORMAT(/,'%% ERREUR EVADIM : ERREUR DE MAILLAGE',/,
     &       20X,'En modele coque, toute la coque doit etre couplee ',
     &           'au fluide',/,
     &       20X,'Ici, la coque comporte ',I9,' noeuds',/,
     &       20X,'Il y en a ',I9,' de declares couples')
 6100 FORMAT(/,'  %% ERREUR EVADIM : TYPE DE MAILLAGE POUR LE',
     &         ' RAYONNEMENT INCONNU')
 7600 FORMAT(/,' $$ ATTENTION EVADIM : LECTURE OU ECRITURE DES ',
     &        'CORRESPONDANTS',
     &   13X,' Ces options sont sans objet en solide mobile ',
     &        'puisque les correspondants',/,
     &   13X,' sont recalcules tous les pas de temps',/,
     &   13X,' Ces options sont igorees, le calcul se poursuit de',
     &        'facon normale...')
C
 8000 FORMAT(/,' *** EVADIM : CARACTERISTIQUES DU MAILLAGE SOLIDE',
     &       '  ELEMENTS FINIS : ',/,
     &         '              NOMBRE DE ...',/,
     &   15X,'- noeuds                                  ',I9,/, 
     &   15X,'- elements volumiques                     ',I9,/,
     &   15X,'- elements de bord de type flux           ',I9,/,
     &   15X,'- elements de bord couples                ',I9,/,
     &   15X,'- noeuds couples                          ',I9,/,
     &   15X,'- noeuds avec CL flux                     ',I9,/,
     &   15X,'- noeuds avec CL Dirichlet                ',I9,/,
     &   15X,'- noeuds avec CL coefficient d''echange    ',I9)
 8010 FORMAT(
     &   15X,'- elts de bord avec resistance de contact ',I9,/,
     &   15X,'- noeuds avec resistance de contact       ',I9,/,
     &   15X,'- elements volumiques periodiques         ',I9,/,
     &   15X,'- noeuds periodiques                      ',I9,/,
     &   15X,'- elements surfaciques avec rayt confine  ',I9,/,
     &   15X,'- noeuds avec rayonnement confine         ',I9,/,
     &   15X,'- noeuds avec rayonnement infini          ',I9,/,
     &   15X,'- noeuds en rotation                      ',I9)
 8011 FORMAT(
     &   15X,'- noeuds avec flux volumique              ',I9)
 8012 FORMAT(
     &   15X,'- elements avec flux volumique            ',I9)
 8015 FORMAT(/,' *** EVADIM : CARACTERISTIQUES DU MAILLAGE DE',
     &       '  RAYONNEMENT : ',/,
     &         '              NOMBRE DE ...',/,
     &   15X,'- maillage rayonnement - nombre de noeuds ',I9,/,
     &   15X,'- maillage rayonnement - nombre d''elements',I9,/,
     &   15X,'- facettes couplees avec le solide        ',I9,/,
     &   15X,'- facettes couplees avec le fluide        ',I9,/,
     &   15X,'- facettes a temperature imposee          ',I9,/,
     &   15X,'- facettes a flux impose                  ',I9,/,
     &   15X,'- facettes de type paroi equivalente      ',I9,/,
     &   15X,'- facettes de type milieu semi transparent',I9,/,
     &   15X,'- noeuds couples avec le solide           ',I9,/,
     &   15X,'- noeuds couples avec le fluide           ',I9)
 8020 FORMAT(/,' *** EVADIM : CARACTERISTIQUES DU MAILLAGE SOLIDE', 
     &       '  ELEMENTS FINIS : ',/,
     &         '              NOMBRE DE ...',/,
     &   15X,'- noeuds                                  ',I9,/, 
     &   15X,'- elements volumiques                     ',I9,/,
     &   15X,'- elements de bord de type flux           ',I9,/,
     &   15X,'- faces couplees                          ',I9,/,
     &   15X,'- noeuds couples                          ',I9,/,
     &   15X,'- faces avec CL flux                      ',I9,/,
     &   15X,'- noeuds avec CL Dirichlet                ',I9,/,
     &   15X,'- faces avec CL coefficient d''echange     ',I9)
 8030 FORMAT(
     &   15X,'- faces avec resistance de contact        ',I9,/,
     &   15X,'- noeuds avec resistance de contact       ',I9,/,
     &   15X,'- elements volumiques periodiques         ',I9,/,
     &   15X,'- noeuds periodiques                      ',I9,/,
     &   15X,'- elements surfaciques avec rayt confine  ',I9,/,
     &   15X,'- noeuds avec rayonnement confine         ',I9,/,
     &   15X,'- faces avec rayonnement infini           ',I9,/,
     &   15X,'- noeuds en rotation                      ',I9)
C
 9100 FORMAT(/,'  %% ERREUR EVADIM : LES RESISTANCES DE CONTACT',
     &         ' NE SONT PAS AUTORISEES EN MODELE COQUE')
 9200 FORMAT(/,'  %% ERREUR EVADIM : Rayonnement confine :',/,
     & 20X,'Aucun element de rayonnement n''est couple au solide')
C----
C FIN
C----
C
      RETURN
      END

