--[[
Copyright (C) 2013-2014 Draios inc.
 
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License version 2 as
published by the Free Software Foundation.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
--]]

view_info = 
{
	id = "kubernetes_pods",
	name = "K8s Pods",
	description = "List all Kubernetes pods running on this machine, and the resources that each of them uses.",
	tips = {"Select a pod and click enter to drill down into it. At that point, you will be able to access several views that will show you the details of the selected pod."},
	view_type = "table",
	applies_to = {"", "evt.res", "k8s.rc.id", "k8s.svc.id", "k8s.ns.id"},
	filter = "k8s.pod.id != ''",
	use_defaults = true,
	drilldown_target = "containers",
	columns = 
	{
		{
			name = "NA",
			field = "thread.tid",
			is_key = true
		},
		{
			name = "CPU",
			field = "thread.cpu",
			description = "Amount of CPU used by the pod.",
			colsize = 8,
			aggregation = "AVG",
			groupby_aggregation = "SUM",
			is_sorting = true
		},
		{
			name = "VIRT",
			field = "thread.vmsize.b",
			description = "Total virtual memory for the pod.",
			aggregation = "MAX",
			groupby_aggregation = "SUM",
			colsize = 9
		},
		{
			name = "RES",
			field = "thread.vmrss.b",
			description = "Resident non-swapped memory for the pod.",
			aggregation = "MAX",
			groupby_aggregation = "SUM",
			colsize = 9
		},
		{
			name = "FILE",
			field = "evt.buflen.file",
			description = "Total (input+output) file I/O bandwidth generated by the pod, in bytes per second.",
			colsize = 8,
			aggregation = "TIME_AVG",
			groupby_aggregation = "SUM"
		},
		{
			name = "NET",
			field = "evt.buflen.net",
			description = "Total (input+output) network bandwidth generated by the pod, in bytes per second.",
			colsize = 8,
			aggregation = "TIME_AVG",
			groupby_aggregation = "SUM"
		},
		{
			name = "NA",
			field = "k8s.pod.id",
			is_groupby_key = true
		},
		{
			name = "ID",
			field = "k8s.pod.id",
			description = "Pod name.",
			colsize = 38
		},
		{
			name = "NAME",
			field = "k8s.pod.name",
			description = "Pod name.",
			colsize = 25
		},
		{
			name = "NAMESPACE",
			field = "k8s.ns.name",
			description = "Pod namespace.",
			colsize = 20
		},
		{
			name = "LABELS",
			field = "k8s.pod.labels",
			description = "Pod labels.",
			colsize = 0
		},
	},
	actions = 
	{
		{
			hotkey = "d",
			command = "kubectl --namespace=%k8s.ns.name describe pods %k8s.pod.name",
			description = "describe"
		},
		{
			hotkey = "x",
			command = "kubectl --namespace=%k8s.ns.name delete pods %k8s.pod.name",
			description = "delete"
		},
		{
			hotkey = "b",
			command = "kubectl --namespace=%k8s.ns.name exec %k8s.pod.name -i -t -- /bin/bash",
			description = "bash shell"
		},
		{
			hotkey = "l",
			command = "kubectl --namespace=%k8s.ns.name logs %k8s.pod.name",
			description = "log"
		},
		{
			hotkey = "f",
			command = "kubectl --namespace=%k8s.ns.name logs -f %k8s.pod.name",
			description = "follow log"
		},
		{
			hotkey = "o",
			command = "kubectl --namespace=%k8s.ns.name logs -p %k8s.pod.name",
			description = "previous log"
		}
	}
}
